/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.tracing;

import org.eclipse.dd.gdb.internal.provisional.launching.ITracedLaunch;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.tracing.TracingConsole;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class TracingConsoleManager
implements ILaunchesListener2,
IPropertyChangeListener {
    private boolean fTracingEnabled = false;

    public void startup() {
        GdbUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        this.fTracingEnabled = store.getBoolean("tracesEnable");
        if (this.fTracingEnabled) {
            this.toggleTracing(true);
        }
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeAllConsoles();
    }

    protected void toggleTracing(boolean enabled) {
        if (enabled) {
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
            this.addAllConsoles();
        } else {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            this.removeAllConsoles();
        }
    }

    protected void addAllConsoles() {
        ILaunch[] launches;
        for (ILaunch launch : launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            this.addConsole(launch);
        }
    }

    protected void removeAllConsoles() {
        ILaunch[] launches;
        for (ILaunch launch : launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            this.removeConsole(launch);
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            this.addConsole(launch);
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            this.removeConsole(launch);
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            this.renameConsole(launch);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("tracesEnable")) {
            this.fTracingEnabled = (Boolean)event.getNewValue();
            this.toggleTracing(this.fTracingEnabled);
        }
    }

    protected void addConsole(ILaunch launch) {
        if (launch instanceof ITracedLaunch && this.getConsole(launch) == null && !launch.isTerminated()) {
            TracingConsole console = new TracingConsole(launch, "gdb traces");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
    }

    protected void removeConsole(ILaunch launch) {
        TracingConsole console;
        if (launch instanceof ITracedLaunch && (console = this.getConsole(launch)) != null) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
        }
    }

    protected void renameConsole(ILaunch launch) {
        TracingConsole console;
        if (launch instanceof ITracedLaunch && (console = this.getConsole(launch)) != null) {
            console.resetName();
        }
    }

    private TracingConsole getConsole(ILaunch launch) {
        IConsole[] consoles;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        for (IConsole console : consoles = manager.getConsoles()) {
            TracingConsole tracingConsole;
            if (!(console instanceof TracingConsole) || !(tracingConsole = (TracingConsole)console).getLaunch().equals(launch)) continue;
            return tracingConsole;
        }
        return null;
    }
}

