/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.memory;

import org.eclipse.dd.dsf.debug.internal.provisional.model.IMemoryBlockUpdatePolicyProvider;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RefreshAction
implements IViewActionDelegate {
    private IMemoryBlock fMemoryBlock = null;
    private MemoryView fView;

    public void init(IViewPart view) {
        this.fView = (MemoryView)view;
    }

    public void run(IAction action) {
        if (this.fMemoryBlock instanceof IMemoryBlockUpdatePolicyProvider) {
            ((IMemoryBlockUpdatePolicyProvider)this.fMemoryBlock).clearCache();
            IMemoryRenderingContainer[] containers = this.fView.getMemoryRenderingContainers();
            for (int i = 0; i < containers.length; ++i) {
                IMemoryRendering[] renderings = containers[i].getRenderings();
                for (int j = 0; j < renderings.length; ++j) {
                    if (!(renderings[j].getControl() instanceof IDebugEventSetListener)) continue;
                    ((IDebugEventSetListener)renderings[j].getControl()).handleDebugEvents(new DebugEvent[]{new DebugEvent((Object)this.fMemoryBlock, 16)});
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fMemoryBlock = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryBlock) {
                this.fMemoryBlock = (IMemoryBlock)((IStructuredSelection)selection).getFirstElement();
                action.setEnabled(true);
            } else if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryRendering) {
                this.fMemoryBlock = ((IMemoryRendering)((IStructuredSelection)selection).getFirstElement()).getMemoryBlock();
                action.setEnabled(true);
            }
        }
    }
}

