/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.eclipse.dd.ipxact.editor.core.document.Choice;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.NamespaceContextHelper;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SpiritDocument
extends SpiritNode {
    public static final String SPIRIT_NS_PREFIX = "spirit";
    public static final String SPIRIT_NS_PREFIX_COLON = "spirit:";
    protected Document base;
    private static XPathFactory xpathFactory = XPathFactory.newInstance();

    protected SpiritDocument(Document xmlDoc) {
        super(xmlDoc.getDocumentElement());
        this.base = xmlDoc;
    }

    public abstract String getRootTagName();

    public Document getBaseDocument() {
        return this.base;
    }

    public String getVLNVcomponent(String VLNVcomponent) {
        NodeList vendorlist = this.getDescendants(VLNVcomponent);
        String VLNVtext = null;
        for (Node cnode = vendorlist.item(0); cnode != null; cnode = cnode.getNextSibling()) {
            Node tnode;
            if (cnode.getNodeType() != 1 || !cnode.getLocalName().equals(VLNVcomponent)) continue;
            for (tnode = cnode.getFirstChild(); tnode != null && tnode.getNodeType() != 3; tnode = tnode.getNextSibling()) {
            }
            if (tnode == null) continue;
            VLNVtext = tnode.getNodeValue();
            break;
        }
        return VLNVtext;
    }

    public String[] attributeValueSuggestions(Node node, String attribute) {
        if (attribute.endsWith("vendor")) {
            ArrayList<String> vendors = SpiritResourceLibrary.getDefault().getVendors();
            return vendors.toArray(new String[0]);
        }
        if (attribute.endsWith("library")) {
            NamedNodeMap attributes;
            Node vendorAttribute;
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null && (vendorAttribute = (attributes = node.getAttributes()).getNamedItem(node.getPrefix() + ":vendor")) != null) {
                ArrayList<String> libraries = SpiritResourceLibrary.getDefault().getLibraries(vendorAttribute.getNodeValue());
                return libraries.toArray(new String[0]);
            }
        } else if (attribute.endsWith("name")) {
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null) {
                NamedNodeMap attributes = node.getAttributes();
                Node vendorAttribute = attributes.getNamedItem(node.getPrefix() + ":vendor");
                Node libraryAttribute = attributes.getNamedItem(node.getPrefix() + ":library");
                if (vendorAttribute != null && libraryAttribute != null) {
                    ArrayList<String> names = SpiritResourceLibrary.getDefault().getNames(vendorAttribute.getNodeValue(), libraryAttribute.getNodeValue());
                    return names.toArray(new String[0]);
                }
            }
        } else if (attribute.endsWith("version")) {
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null) {
                NamedNodeMap attributes = node.getAttributes();
                Node vendorAttribute = attributes.getNamedItem(node.getPrefix() + ":vendor");
                Node libraryAttribute = attributes.getNamedItem(node.getPrefix() + ":library");
                Node nameAttribute = attributes.getNamedItem(node.getPrefix() + ":name");
                if (vendorAttribute != null && libraryAttribute != null && nameAttribute != null) {
                    ArrayList<String> versions = SpiritResourceLibrary.getDefault().getVersions(vendorAttribute.getNodeValue(), libraryAttribute.getNodeValue(), nameAttribute.getNodeValue());
                    return versions.toArray(new String[0]);
                }
            }
        }
        return new String[0];
    }

    public String[] elementValueSuggestions(Node node, String name) {
        if (name.endsWith("vendor")) {
            ArrayList<String> vendors = SpiritResourceLibrary.getDefault().getVendors();
            return vendors.toArray(new String[0]);
        }
        if (name.endsWith("library")) {
            String vendor = this.getVLNVcomponent("vendor");
            ArrayList<String> libraries = SpiritResourceLibrary.getDefault().getLibraries(vendor);
            return libraries.toArray(new String[0]);
        }
        if (name.endsWith("name") && node.getParentNode().getParentNode().getNodeType() == 9) {
            String vendor = this.getVLNVcomponent("vendor");
            String libname = this.getVLNVcomponent("library");
            ArrayList<String> names = SpiritResourceLibrary.getDefault().getNames(vendor, libname);
            return names.toArray(new String[0]);
        }
        if (name.endsWith("version")) {
            String vendor = this.getVLNVcomponent("vendor");
            String libname = this.getVLNVcomponent("library");
            String cname = this.getVLNVcomponent("name");
            ArrayList<String> versions = SpiritResourceLibrary.getDefault().getVersions(vendor, libname, cname);
            return versions.toArray(new String[0]);
        }
        return new String[0];
    }

    public Vlnv getVlnv() {
        return Vlnv.getVlnvForXmlDocument(this.base);
    }

    public void setVlnv(Vlnv vlnv) {
        Element e = this.getDocumentElement();
        String[] vlnv_elements = new String[]{vlnv.getVendor(), vlnv.getLibrary(), vlnv.getName(), vlnv.getVersion()};
        int ecount = 0;
        block0: for (Node n = e.getFirstChild(); n != null && ecount < 4; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            for (int i = 0; i < 4; ++i) {
                if (!n.getNodeName().equals(n.getPrefix() + Vlnv.VLNV_TAG_NAMES[i])) continue;
                Node t = n.getFirstChild();
                while (t.getNodeType() != 3) {
                    t = t.getNextSibling();
                }
                t.setNodeValue(vlnv_elements[i]);
                ++ecount;
                continue block0;
            }
        }
    }

    public static String getSchemaURI(Document doc) {
        String uri = null;
        Element e = doc.getDocumentElement();
        if (e != null) {
            uri = e.getNamespaceURI();
        }
        return uri;
    }

    public Element getDocumentElement() {
        return this.base.getDocumentElement();
    }

    public XPath createXPath() {
        XPath xpath = xpathFactory.newXPath();
        NamespaceContextHelper context = new NamespaceContextHelper(SPIRIT_NS_PREFIX, this.getNamespaceURI());
        xpath.setNamespaceContext(context);
        return xpath;
    }

    public static XPath createXPath(String namespaceUri) {
        XPath xpath = xpathFactory.newXPath();
        NamespaceContextHelper context = new NamespaceContextHelper(SPIRIT_NS_PREFIX, namespaceUri);
        xpath.setNamespaceContext(context);
        return xpath;
    }

    public String toString() {
        return String.valueOf(this.getVlnv());
    }

    public Choice getChoice(String name) {
        return this.getNamedSubitem("choice", name, Choice.class);
    }
}

