/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.StackTraceWrapper;
import org.eclipse.dd.dsf.internal.DsfPlugin;

@Immutable
public class DsfExecutable {
    static boolean DEBUG_EXECUTOR = false;
    static boolean ASSERTIONS_ENABLED = false;
    final StackTraceWrapper fCreatedAt;
    final DefaultDsfExecutor.TracingWrapper fCreatedBy;
    private volatile boolean fSubmitted = false;

    public DsfExecutable() {
        if (ASSERTIONS_ENABLED || DEBUG_EXECUTOR) {
            int i;
            DefaultDsfExecutor executor = DefaultDsfExecutor.fThreadToExecutorMap.get(Thread.currentThread());
            this.fCreatedBy = executor != null ? executor.fCurrentlyExecuting : null;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            HashSet<String> classNamesSet = new HashSet<String>();
            for (Class<?> thisClass = this.getClass(); thisClass != null; thisClass = thisClass.getSuperclass()) {
                classNamesSet.add(thisClass.getName());
            }
            for (i = 3; i < stackTrace.length && classNamesSet.contains(stackTrace[i].getClassName()); ++i) {
            }
            this.fCreatedAt = new StackTraceWrapper(new StackTraceElement[stackTrace.length - i]);
            System.arraycopy(stackTrace, i, this.fCreatedAt.fStackTraceElements, 0, this.fCreatedAt.fStackTraceElements.length);
        } else {
            this.fCreatedAt = null;
            this.fCreatedBy = null;
        }
    }

    public boolean getSubmitted() {
        return this.fSubmitted;
    }

    public void setSubmitted() {
        this.fSubmitted = true;
    }

    protected boolean isExecutionRequired() {
        return true;
    }

    protected void finalize() {
        if (DEBUG_EXECUTOR && !this.fSubmitted && this.isExecutionRequired()) {
            StringBuilder traceBuilder = new StringBuilder();
            traceBuilder.append(DsfPlugin.getDebugTime());
            traceBuilder.append(' ');
            traceBuilder.append("DsfExecutable was never executed:\n        ");
            traceBuilder.append(this);
            traceBuilder.append("\nCreated at:");
            traceBuilder.append(this.fCreatedAt);
            DsfPlugin.debug(traceBuilder.toString());
        }
    }

    static {
        if (!$assertionsDisabled) {
            ASSERTIONS_ENABLED = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        DEBUG_EXECUTOR = DsfPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf/debug/executor"));
    }
}

