/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.ipxact.editor.core.SpiritCorePlugin;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceChangeListener;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;

public class SpiritCoreSaver
implements ISaveParticipant {
    static final int FAILED_TO_SAVE = -1;

    public void doneSaving(ISaveContext context) {
        SpiritCorePlugin myPluginInstance = SpiritCorePlugin.getDefault();
        int previousSaveNumber = context.getPreviousSaveNumber();
        String oldFileName = "library-save-" + Integer.toString(previousSaveNumber);
        File f = myPluginInstance.getStateLocation().append(oldFileName).toFile();
        f.delete();
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
        SpiritCorePlugin myPluginInstance = SpiritCorePlugin.getDefault();
        int saveNumber = context.getSaveNumber();
        String saveFileName = "save-" + Integer.toString(saveNumber);
        File f = myPluginInstance.getStateLocation().append(saveFileName).toFile();
        f.delete();
    }

    public void saving(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            SpiritCorePlugin myPluginInstance = SpiritCorePlugin.getDefault();
            int saveNumber = context.getSaveNumber();
            String saveFileName = "library-save-" + Integer.toString(saveNumber);
            File f = myPluginInstance.getStateLocation().append(saveFileName).toFile();
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(SpiritResourceLibrary.getDefault());
                out.close();
            }
            catch (IOException e) {
                CoreException ce = new CoreException((IStatus)new Status(4, "org.eclipse.dd.ipxact.editor.core", -1, "Failed to save IP-XACT library", (Throwable)e));
                throw ce;
            }
            context.map((IPath)new Path("library-save"), (IPath)new Path(saveFileName));
            context.needSaveNumber();
            context.needDelta();
        }
    }

    public boolean restoreState(SpiritCorePlugin plugin, ISavedState state) {
        if (state == null) {
            return false;
        }
        IPath location = state.lookup((IPath)new Path("library-save"));
        if (location == null) {
            return false;
        }
        File f = plugin.getStateLocation().append(location).toFile();
        try {
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream in = new ObjectInputStream(fis);
            SpiritResourceLibrary.setDefault((SpiritResourceLibrary)in.readObject());
            in.close();
        }
        catch (Exception e) {
            return false;
        }
        state.processResourceChangeEvents((IResourceChangeListener)new SpiritResourceChangeListener(SpiritResourceLibrary.getDefault()));
        return true;
    }
}

