/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIListThreadGroupsInfo
extends MIInfo {
    private IThreadGroupInfo[] fGroupList;
    private MIThreadInfoInfo fThreadInfo;

    public MIListThreadGroupsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public IThreadGroupInfo[] getGroupList() {
        return this.fGroupList;
    }

    public MIThreadInfoInfo getThreadInfo() {
        return this.fThreadInfo;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (var.equals("groups")) {
                    MIValue val = results[i].getMIValue();
                    if (!(val instanceof MIList)) continue;
                    this.parseGroups((MIList)val);
                    continue;
                }
                if (!var.equals("threads")) continue;
                this.fThreadInfo = new MIThreadInfoInfo(out);
            }
        }
        if (this.fGroupList == null) {
            this.fGroupList = new IThreadGroupInfo[0];
        }
        if (this.fThreadInfo == null) {
            this.fThreadInfo = new MIThreadInfoInfo(null);
        }
    }

    private void parseGroups(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fGroupList = new IThreadGroupInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            MIResult[] results = ((MITuple)values[i]).getMIResults();
            String id = "";
            String desc = "";
            for (MIResult result : results) {
                String str;
                MIValue value;
                String var = result.getVariable();
                if (var.equals("id")) {
                    value = result.getMIValue();
                    if (!(value instanceof MIConst)) continue;
                    str = ((MIConst)value).getCString();
                    id = str.trim();
                    continue;
                }
                if (!var.equals("description") || !((value = result.getMIValue()) instanceof MIConst)) continue;
                str = ((MIConst)value).getCString();
                desc = str.trim();
            }
            this.fGroupList[i] = new ThreadGroupInfo(id, desc);
        }
    }

    @Immutable
    private static class ThreadGroupInfo
    implements IThreadGroupInfo {
        final String fGroupId;
        final String fDescription;
        final String fName;

        public ThreadGroupInfo(String id, String description) {
            this.fGroupId = id;
            this.fDescription = description;
            this.fName = ThreadGroupInfo.parseName(this.fDescription);
        }

        private static String parseName(String desc) {
            String name = "";
            Pattern pattern = Pattern.compile("name: (.*?)(, |$)", 8);
            Matcher matcher = pattern.matcher(desc);
            if (matcher.find()) {
                name = matcher.group(1);
            }
            return name;
        }

        public String getGroupId() {
            return this.fGroupId;
        }

        public String getPid() {
            return this.fGroupId;
        }

        public String getName() {
            return this.fName;
        }

        public String getDesciption() {
            return this.fDescription;
        }
    }

    public static interface IThreadGroupInfo {
        public String getGroupId();

        public String getPid();

        public String getName();

        public String getDesciption();
    }
}

