/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.framework;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.eclipse.swt.widgets.Display;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundRunner
extends TestClassRunner {
    static final QualifiedName BACKGROUND_TEST_EXECUTION_FINISHED = new QualifiedName(TestsPlugin.getDefault().getBundle().getSymbolicName(), "background_test_execution_finished");

    public BackgroundRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    void invokeSuperRunImpl(RunNotifier notifier) {
        super.run(notifier);
    }

    public void run(final RunNotifier notifier) {
        Job job = new Job("GDB/MI JUnit Test Case Execution Job"){

            protected IStatus run(IProgressMonitor monitor) {
                BackgroundRunner.this.invokeSuperRunImpl(notifier);
                monitor.done();
                this.setProperty(BACKGROUND_TEST_EXECUTION_FINISHED, Boolean.TRUE);
                return Status.OK_STATUS;
            }
        };
        job.setProperty(BACKGROUND_TEST_EXECUTION_FINISHED, (Object)Boolean.FALSE);
        job.schedule();
        BackgroundRunner.waitAndDispatch(0L, new BackgroundTestExecutionJobWaiter(job));
    }

    public static boolean waitAndDispatch(long timeout, IInterruptCondition condition) {
        assert (timeout >= 0L && condition != null);
        boolean isTimedOut = false;
        if (timeout >= 0L && condition != null) {
            long start = System.currentTimeMillis();
            Display display = Display.findDisplay((Thread)Thread.currentThread());
            if (display != null) {
                long current = System.currentTimeMillis();
                while (!(timeout != 0L && current - start >= timeout || condition.isTrue())) {
                    if (!display.readAndDispatch()) {
                        display.sleep();
                    }
                    current = System.currentTimeMillis();
                }
                isTimedOut = current - start >= timeout && timeout > 0L;
            } else {
                long current = System.currentTimeMillis();
                while (!(timeout != 0L && current - start >= timeout || condition.isTrue())) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    current = System.currentTimeMillis();
                }
                isTimedOut = current - start >= timeout && timeout > 0L;
            }
        }
        condition.dispose();
        return isTimedOut;
    }

    private static final class BackgroundTestExecutionJobWaiter
    implements IInterruptCondition {
        private final Job job;

        public BackgroundTestExecutionJobWaiter(Job job) {
            assert (job != null);
            this.job = job;
        }

        public boolean isTrue() {
            return (Boolean)this.job.getProperty(BACKGROUND_TEST_EXECUTION_FINISHED);
        }

        public void dispose() {
        }
    }

    public static interface IInterruptCondition {
        public boolean isTrue();

        public void dispose();
    }
}

