/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.actions;

import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.AbstractLaunchVMProvider;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ExpandStackAction
extends AbstractVMProviderActionDelegate
implements IObjectActionDelegate {
    public void run(IAction action) {
        Object element = this.getViewerInput();
        if (element instanceof StackFramesVMNode.IncompleteStackVMContext) {
            StackFramesVMNode.IncompleteStackVMContext incStackVmc = (StackFramesVMNode.IncompleteStackVMContext)((Object)element);
            IVMNode node = incStackVmc.getVMNode();
            if (incStackVmc.getVMNode() instanceof StackFramesVMNode) {
                IRunControl.IExecutionDMContext exeCtx = incStackVmc.getExecutionDMContext();
                ((StackFramesVMNode)node).incrementStackFrameLimit(exeCtx);
                final ExpandStackEvent event = new ExpandStackEvent(exeCtx);
                final AbstractLaunchVMProvider vmProvider = (AbstractLaunchVMProvider)this.getVMProvider();
                vmProvider.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        vmProvider.handleEvent((Object)event);
                    }
                });
            }
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        this.updateEnablement();
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.updateEnablement();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enabled = false;
        if (this.getVMProvider() instanceof AbstractLaunchVMProvider) {
            Object element = this.getViewerInput();
            enabled = element instanceof StackFramesVMNode.IncompleteStackVMContext;
        }
        this.getAction().setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof IViewPart) {
            this.init((IViewPart)targetPart);
        }
    }
}

