/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StepQueueManager
extends AbstractDsfService
implements IStepQueueManager {
    public static final int STEPPING_TIMEOUT = 500;
    public static final int STEP_QUEUE_DEPTH = 3;
    private IRunControl fRunControl;
    private int fQueueDepth = 3;
    private Map<IRunControl.IExecutionDMContext, List<StepRequest>> fStepQueues = new HashMap<IRunControl.IExecutionDMContext, List<StepRequest>>();
    private Map<IRunControl.IExecutionDMContext, Boolean> fTimedOutFlags = new HashMap<IRunControl.IExecutionDMContext, Boolean>();
    private Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fTimedOutFutures = new HashMap();

    public StepQueueManager(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                StepQueueManager.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{StepQueueManager.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfDebugPlugin.getBundleContext();
    }

    @Override
    public void canEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        if (this.doCanEnqueueStep(execCtx, stepType)) {
            rm.setData((Object)true);
            rm.done();
        } else {
            this.fRunControl.canStep(execCtx, stepType, rm);
        }
    }

    private boolean doCanEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        return this.fRunControl.isStepping(execCtx) && !this.isSteppingTimedOut(execCtx);
    }

    public int getPendingStepCount(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
        if (stepQueue == null) {
            return 0;
        }
        return stepQueue.size();
    }

    @Override
    public void enqueueStep(final IRunControl.IExecutionDMContext execCtx, final IRunControl.StepType stepType) {
        this.fRunControl.canStep(execCtx, stepType, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                    StepQueueManager.this.fRunControl.step(execCtx, stepType, new RequestMonitor((Executor)StepQueueManager.this.getExecutor(), null));
                } else if (StepQueueManager.this.doCanEnqueueStep(execCtx, stepType)) {
                    LinkedList<StepRequest> stepQueue = (LinkedList<StepRequest>)StepQueueManager.this.fStepQueues.get(execCtx);
                    if (stepQueue == null) {
                        stepQueue = new LinkedList<StepRequest>();
                        StepQueueManager.this.fStepQueues.put(execCtx, stepQueue);
                    }
                    if (stepQueue.size() < StepQueueManager.this.fQueueDepth) {
                        stepQueue.add(new StepRequest(stepType));
                    }
                }
            }
        });
    }

    public boolean isSteppingTimedOut(IRunControl.IExecutionDMContext execCtx) {
        for (IRunControl.IExecutionDMContext timedOutCtx : this.fTimedOutFlags.keySet()) {
            if (!execCtx.equals(timedOutCtx) && !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)timedOutCtx)) continue;
            return this.fTimedOutFlags.get(timedOutCtx);
        }
        return false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.ISuspendedDMEvent e) {
        this.fTimedOutFlags.remove(e.getDMContext());
        ScheduledFuture<?> future = this.fTimedOutFutures.remove(e.getDMContext());
        if (future != null) {
            future.cancel(false);
        }
        if (this.fStepQueues.containsKey(e.getDMContext())) {
            List<StepRequest> queue = this.fStepQueues.get(e.getDMContext());
            final StepRequest request = queue.remove(queue.size() - 1);
            if (queue.isEmpty()) {
                this.fStepQueues.remove(e.getDMContext());
            }
            this.fRunControl.canStep((IRunControl.IExecutionDMContext)e.getDMContext(), request.fStepType, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                        StepQueueManager.this.fRunControl.step((IRunControl.IExecutionDMContext)e.getDMContext(), request.fStepType, new RequestMonitor((Executor)StepQueueManager.this.getExecutor(), null));
                    } else {
                        StepQueueManager.this.fStepQueues.remove(e.getDMContext());
                    }
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.IResumedDMEvent e) {
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.FALSE);
            assert (!this.fTimedOutFutures.containsKey(e.getDMContext()));
            this.fTimedOutFutures.put((IRunControl.IExecutionDMContext)e.getDMContext(), this.getExecutor().schedule((Runnable)new DsfRunnable(){

                public void run() {
                    StepQueueManager.this.fTimedOutFutures.remove(e.getDMContext());
                    if (StepQueueManager.this.getSession().isActive()) {
                        StepQueueManager.this.getSession().dispatchEvent((Object)new ISteppingTimedOutEvent(){

                            public IRunControl.IExecutionDMContext getDMContext() {
                                return (IRunControl.IExecutionDMContext)e.getDMContext();
                            }
                        }, StepQueueManager.this.getProperties());
                    }
                }
            }, 500L, TimeUnit.MILLISECONDS));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ISteppingTimedOutEvent e) {
        this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.TRUE);
    }

    private static class StepRequest {
        IRunControl.StepType fStepType;

        StepRequest(IRunControl.StepType type) {
            this.fStepType = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISteppingTimedOutEvent
    extends IDMEvent<IRunControl.IExecutionDMContext> {
    }
}

