/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IAsmLanguage;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.TokenStore;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.CSourceTagProvider;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourcePresentationCreator;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagListener;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagProvider;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.SourceTagDamagerRepairer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourcePresentationCreator
extends PresentationReconciler
implements ISourcePresentationCreator,
IPropertyChangeListener {
    private ITextViewer fViewer;
    private ISourceTagProvider fSourceTagProvider;
    private SourceTagDamagerRepairer fDamagerRepairer;
    private ISourceTagListener fSourceTagListener;
    private TextPresentation fPresentation;
    private CustomCSourceViewerConfiguration fSourceViewerConfiguration;
    private IPreferenceStore fPreferenceStore;

    public CSourcePresentationCreator(ILanguage language, IStorage storage, ITextViewer textViewer) {
        if (language != null) {
            this.fViewer = textViewer;
            this.fPreferenceStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
            CTextTools textTools = CUIPlugin.getDefault().getTextTools();
            this.fSourceViewerConfiguration = new CustomCSourceViewerConfiguration((IColorManager)textTools.getColorManager(), this.fPreferenceStore, language);
            this.setDocumentPartitioning(this.fSourceViewerConfiguration.getConfiguredDocumentPartitioning(null));
            this.initializeDamagerRepairer(storage, (IColorManager)textTools.getColorManager(), this.fPreferenceStore);
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void initializeDamagerRepairer(IStorage storage, IColorManager colorManager, IPreferenceStore store) {
        String[] contentTypes = this.fSourceViewerConfiguration.getConfiguredContentTypes(null);
        for (int i = 0; i < contentTypes.length; ++i) {
            String contentType = contentTypes[i];
            ITokenScanner scanner = this.fSourceViewerConfiguration.getScannerForContentType(contentType);
            if (scanner == null) continue;
            if (this.fDamagerRepairer == null) {
                this.fSourceTagProvider = this.createSourceTagProvider(storage);
                this.fDamagerRepairer = new SourceTagDamagerRepairer(scanner, this.fSourceTagProvider, colorManager, store);
                if (this.fSourceTagProvider != null) {
                    if (this.fSourceTagListener == null) {
                        this.fSourceTagListener = new ISourceTagListener(){

                            public void sourceTagsChanged(ISourceTagProvider provider) {
                                CSourcePresentationCreator.this.handleSourceTagsChanged();
                            }
                        };
                    }
                    this.fSourceTagProvider.addSourceTagListener(this.fSourceTagListener);
                }
            }
            this.fDamagerRepairer.setScanner(contentType, scanner);
            this.setDamager((IPresentationDamager)this.fDamagerRepairer, contentType);
            this.setRepairer((IPresentationRepairer)this.fDamagerRepairer, contentType);
        }
    }

    public void dispose() {
        this.fViewer = null;
        this.fPresentation = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        if (this.fSourceViewerConfiguration != null) {
            this.fSourceViewerConfiguration.dispose();
            this.fSourceViewerConfiguration = null;
        }
        if (this.fSourceTagProvider != null) {
            if (this.fSourceTagListener != null) {
                this.fSourceTagProvider.removeSourceTagListener(this.fSourceTagListener);
                this.fSourceTagListener = null;
            }
            this.fSourceTagProvider = null;
        }
    }

    public TextPresentation getPresentation(IRegion region, IDocument document) {
        assert (this.fViewer != null);
        if (this.fViewer == null) {
            return null;
        }
        if (this.fPresentation == null) {
            this.setDocumentToDamagers(document);
            this.setDocumentToRepairers(document);
            int docLength = document.getLength();
            if (docLength <= 131072) {
                Region all = new Region(0, docLength);
                this.fPresentation = this.createPresentation((IRegion)all, document);
            } else {
                return this.createPresentation(region, document);
            }
        }
        this.fPresentation.setResultWindow(region);
        return this.fPresentation;
    }

    protected void handleSourceTagsChanged() {
        this.invalidateTextPresentation();
    }

    private void invalidateTextPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation = null;
            if (this.fViewer != null) {
                Display display = this.fViewer.getTextWidget().getDisplay();
                if (display.getThread() != Thread.currentThread()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (CSourcePresentationCreator.this.fViewer != null) {
                                CSourcePresentationCreator.this.fViewer.invalidateTextPresentation();
                            }
                        }
                    });
                } else {
                    this.fViewer.invalidateTextPresentation();
                }
            }
        }
    }

    private ISourceTagProvider createSourceTagProvider(IStorage storage) {
        ITranslationUnit tUnit = null;
        if (storage instanceof IFile) {
            tUnit = (ITranslationUnit)CoreModel.getDefault().create((IFile)storage);
        } else if (storage instanceof IFileState) {
            ICModel cModel = CoreModel.getDefault().getCModel();
            try {
                ICProject[] cProjects = cModel.getCProjects();
                if (cProjects.length > 0) {
                    tUnit = CoreModel.getDefault().createTranslationUnitFrom(cProjects[0], storage.getFullPath());
                }
            }
            catch (CModelException e) {}
        } else {
            IEditorInput input = EditorUtility.getEditorInputForLocation((IPath)storage.getFullPath(), null);
            if (input instanceof ITranslationUnitEditorInput) {
                tUnit = ((ITranslationUnitEditorInput)input).getTranslationUnit();
            }
        }
        if (tUnit != null) {
            return new CSourceTagProvider(tUnit);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fSourceViewerConfiguration.affectsBehavior(event)) {
            this.fSourceViewerConfiguration.handlePropertyChangeEvent(event);
            this.invalidateTextPresentation();
        } else if (this.fDamagerRepairer.affectsBahvior(event)) {
            this.fDamagerRepairer.handlePropertyChangeEvent(event);
            this.invalidateTextPresentation();
        }
    }

    private static final class CustomCSourceViewerConfiguration
    extends SimpleCSourceViewerConfiguration {
        private final ILanguage fLanguage;

        private CustomCSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ILanguage language) {
            super(colorManager, preferenceStore, null, "___c_partitioning", false);
            this.fLanguage = language;
        }

        public void dispose() {
        }

        protected ILanguage getLanguage() {
            return this.fLanguage;
        }

        public ITokenScanner getScannerForContentType(String contentType) {
            if ("__dftl_partition_content_type".equals(contentType)) {
                return this.getLanguage() != null ? this.getCodeScanner(this.getLanguage()) : null;
            }
            if ("__c_character".equals(contentType)) {
                return this.getStringScanner();
            }
            if ("__c_string".equals(contentType)) {
                return this.getStringScanner();
            }
            if ("__c_singleline_comment".equals(contentType)) {
                return this.getSinglelineCommentScanner();
            }
            if ("__c_singleline_doc_comment".equals(contentType)) {
                return this.getSinglelineDocCommentScanner((IResource)this.getProject());
            }
            if ("__c_multiline_comment".equals(contentType)) {
                return this.getMultilineCommentScanner();
            }
            if ("__c_multiline_doc_comment".equals(contentType)) {
                return this.getMultilineDocCommentScanner((IResource)this.getProject());
            }
            if ("__c_preprocessor".equals(contentType)) {
                return this.getPreprocessorScanner(this.getLanguage());
            }
            return null;
        }

        private ITokenScanner getMultilineCommentScanner() {
            return new CCommentScanner(this.getTokenStoreFactory(), "c_single_line_comment");
        }

        private ITokenScanner getSinglelineCommentScanner() {
            return new CCommentScanner(this.getTokenStoreFactory(), "c_multi_line_comment");
        }

        private ICProject internalGetCProject() {
            ITextEditor editor = this.getEditor();
            if (editor == null) {
                return null;
            }
            IWorkingCopy element = null;
            IEditorInput input = editor.getEditorInput();
            IDocumentProvider provider = editor.getDocumentProvider();
            if (provider instanceof CDocumentProvider) {
                CDocumentProvider cudp = (CDocumentProvider)provider;
                element = cudp.getWorkingCopy((Object)input);
            }
            if (element == null) {
                return null;
            }
            return element.getCProject();
        }

        private IProject getProject() {
            ICProject cproject = this.internalGetCProject();
            return cproject != null ? cproject.getProject() : null;
        }

        private ITokenStoreFactory getTokenStoreFactory() {
            return new ITokenStoreFactory(){

                public ITokenStore createTokenStore(String[] propertyColorNames) {
                    return new TokenStore(CustomCSourceViewerConfiguration.this.getColorManager(), CustomCSourceViewerConfiguration.this.fPreferenceStore, propertyColorNames);
                }
            };
        }

        protected RuleBasedScanner getCodeScanner(ILanguage language) {
            if (language instanceof IAsmLanguage) {
                return CUIPlugin.getDefault().getAsmTextTools().getCodeScanner();
            }
            return super.getCodeScanner(language);
        }

        protected RuleBasedScanner getPreprocessorScanner(ILanguage language) {
            if (language instanceof IAsmLanguage) {
                return CUIPlugin.getDefault().getAsmTextTools().getPreprocessorScanner();
            }
            return super.getPreprocessorScanner(language);
        }
    }
}

