/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIThreadListIdsInfo
extends MIInfo {
    int[] threadIds;
    private String[] strThreadIds;

    public MIThreadListIdsInfo(MIOutput out) {
        super(out);
    }

    public int[] getThreadIds() {
        if (this.threadIds == null) {
            String[] tIds = this.getStrThreadIds();
            this.threadIds = new int[tIds.length];
            for (int i = 0; i < tIds.length; ++i) {
                try {
                    this.threadIds[i] = Integer.parseInt(tIds[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.threadIds[i] = 0;
                }
            }
        }
        return this.threadIds;
    }

    public String[] getStrThreadIds() {
        if (this.strThreadIds == null) {
            this.parse();
        }
        return this.strThreadIds;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue val;
                String var = results[i].getVariable();
                if (!var.equals("thread-ids") || !((val = results[i].getMIValue()) instanceof MITuple)) continue;
                this.parseThreadIds((MITuple)val);
            }
        }
        if (this.strThreadIds == null) {
            this.strThreadIds = new String[0];
        }
    }

    void parseThreadIds(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        this.strThreadIds = new String[results.length];
        for (int i = 0; i < results.length; ++i) {
            MIValue value;
            String var = results[i].getVariable();
            if (!var.equals("thread-id") || !((value = results[i].getMIValue()) instanceof MIConst)) continue;
            this.strThreadIds[i] = ((MIConst)value).getCString().trim();
        }
    }
}

