/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.ICachingService;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.command.CommandCache;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.MIFormat;
import org.eclipse.dd.mi.service.command.commands.CLIInfoSharedLibrary;
import org.eclipse.dd.mi.service.command.output.CLIInfoSharedLibraryInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIModules
extends AbstractDsfService
implements IModules,
ICachingService {
    private CommandCache fModulesCache;

    public MIModules(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                MIModules.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fModulesCache = new CommandCache(this.getSession(), (ICommandControl)commandControl);
        this.fModulesCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.register(new String[]{IModules.class.getName(), MIModules.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getModules(final IModules.ISymbolDMContext symCtx, final DataRequestMonitor<IModules.IModuleDMContext[]> rm) {
        if (symCtx != null) {
            this.fModulesCache.execute((ICommand)new CLIInfoSharedLibrary(symCtx), (DataRequestMonitor)new DataRequestMonitor<CLIInfoSharedLibraryInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIModules.this.makeModuleContexts((IDMContext)symCtx, (CLIInfoSharedLibraryInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            rm.setData((Object)new IModules.IModuleDMContext[]{new ModuleDMContext(this, DMContexts.EMPTY_CONTEXTS_ARRAY, "example module 1"), new ModuleDMContext(this, DMContexts.EMPTY_CONTEXTS_ARRAY, "example module 2")});
            rm.done();
        }
    }

    private IModules.IModuleDMContext[] makeModuleContexts(IDMContext symCtxt, CLIInfoSharedLibraryInfo info) {
        CLIInfoSharedLibraryInfo.DsfMISharedInfo[] sharedInfos = info.getMIShared();
        IModules.IModuleDMContext[] modules = new ModuleDMContext[sharedInfos.length];
        int i = 0;
        for (CLIInfoSharedLibraryInfo.DsfMISharedInfo shared : sharedInfos) {
            modules[i++] = new ModuleDMContext(this, new IDMContext[]{symCtxt}, shared.getName());
        }
        return modules;
    }

    public void getModuleData(final IModules.IModuleDMContext dmc, final DataRequestMonitor<IModules.IModuleDMData> rm) {
        assert (dmc != null);
        if (dmc instanceof ModuleDMContext) {
            this.fModulesCache.execute((ICommand)new CLIInfoSharedLibrary(dmc), (DataRequestMonitor)new DataRequestMonitor<CLIInfoSharedLibraryInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIModules.this.createSharedLibInfo((ModuleDMContext)dmc, (CLIInfoSharedLibraryInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DM Context", null));
            rm.done();
        }
    }

    private IModules.IModuleDMData createSharedLibInfo(ModuleDMContext dmc, CLIInfoSharedLibraryInfo info) {
        for (CLIInfoSharedLibraryInfo.DsfMISharedInfo shared : info.getMIShared()) {
            if (!shared.getName().equals(dmc.fFile)) continue;
            return new ModuleDMData(shared.getName(), shared.getFrom(), shared.getTo(), shared.isRead());
        }
        return new ModuleDMData("", "", "", false);
    }

    public void calcAddressInfo(IModules.ISymbolDMContext symCtx, String file, int line, int col, DataRequestMonitor<IModules.AddressRange[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Functionality not supported", null));
        rm.done();
    }

    public void calcLineInfo(IModules.ISymbolDMContext symCtx, IAddress address, DataRequestMonitor<IModules.LineInfo[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Functionality not supported", null));
        rm.done();
    }

    public void flushCache(IDMContext context) {
        this.fModulesCache.reset();
    }

    static class ModuleDMData
    implements IModules.IModuleDMData {
        private final String fFile;
        private final String fFromAddress;
        private final String fToAddress;
        private final boolean fIsSymbolsRead;

        public ModuleDMData(ModuleDMContext dmc) {
            this.fFile = dmc.fFile;
            this.fFromAddress = null;
            this.fToAddress = null;
            this.fIsSymbolsRead = false;
        }

        public ModuleDMData(String fileName, String fromAddress, String toAddress, boolean isSymsRead) {
            this.fFile = fileName;
            this.fFromAddress = fromAddress;
            this.fToAddress = toAddress;
            this.fIsSymbolsRead = isSymsRead;
        }

        public String getFile() {
            return this.fFile;
        }

        public String getName() {
            return this.fFile;
        }

        public long getTimeStamp() {
            return 0L;
        }

        public String getBaseAddress() {
            return this.fFromAddress;
        }

        public String getToAddress() {
            return this.fToAddress;
        }

        public boolean isSymbolsLoaded() {
            return this.fIsSymbolsRead;
        }

        public long getSize() {
            long result = 0L;
            if (this.getBaseAddress() == null || this.getToAddress() == null) {
                return result;
            }
            BigInteger start = MIFormat.getBigInteger(this.getBaseAddress());
            BigInteger end = MIFormat.getBigInteger(this.getToAddress());
            if (end.compareTo(start) > 0) {
                result = end.subtract(start).longValue();
            }
            return result;
        }
    }

    static class ModuleDMContext
    extends AbstractDMContext
    implements IModules.IModuleDMContext {
        private final String fFile;

        ModuleDMContext(MIModules service, IDMContext[] parents, String file) {
            super((IDsfService)service, parents);
            this.fFile = file;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && this.fFile.equals(((ModuleDMContext)((Object)obj)).fFile);
        }

        public int hashCode() {
            return this.baseHashCode() + this.fFile.hashCode();
        }
    }
}

