/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.osgi.framework.BundleContext;

public class GdbPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.dd.gdb";
    private static GdbPlugin plugin;
    private static BundleContext fgBundleContext;

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownActiveLaunches();
        plugin = null;
        super.stop(context);
        fgBundleContext = null;
    }

    public static GdbPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    private void shutdownActiveLaunches() {
        for (ILaunch launch : DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            if (!(launch instanceof GdbLaunch) || !((GdbLaunch)launch).getSession().isActive()) continue;
            final GdbLaunch gdbLaunch = (GdbLaunch)launch;
            Query<Object> launchShutdownQuery = new Query<Object>(){

                protected void execute(DataRequestMonitor<Object> rm) {
                    gdbLaunch.shutdownSession((RequestMonitor)rm);
                }
            };
            try {
                gdbLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
            }
            catch (RejectedExecutionException e) {
                break;
            }
            try {
                launchShutdownQuery.get();
            }
            catch (InterruptedException e) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "InterruptedException while shutting down PDA debugger launch " + gdbLaunch, e.getCause()));
            }
            catch (ExecutionException e) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Exception while shutting down PDA debugger launch " + gdbLaunch, e.getCause()));
            }
        }
    }
}

