/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.events;

import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.tests.dsf.DsfTestPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractService
extends AbstractDsfService {
    int fEvent1RecipientNumber;
    int fEvent2RecipientNumber;
    int fEvent3RecipientNumber;

    AbstractService(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return DsfTestPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                AbstractService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    @ThreadSafe
    public void dispatchEvent1() {
        this.getSession().dispatchEvent((Object)new Event1(), this.getProperties());
    }

    @ThreadSafe
    public void dispatchEvent2() {
        this.getSession().dispatchEvent((Object)new Event2(), this.getProperties());
    }

    @ThreadSafe
    public void dispatchEvent3() {
        this.getSession().dispatchEvent((Object)new Event3(), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(Event1 e) {
        this.fEvent1RecipientNumber = e.fRecipientNumberCounter++;
    }

    @DsfServiceEventHandler
    public void eventDispatched(Event2 e) {
        this.fEvent2RecipientNumber = e.fRecipientNumberCounter++;
    }

    @DsfServiceEventHandler
    public void eventDispatched(Event3 e) {
        this.fEvent3RecipientNumber = e.fRecipientNumberCounter++;
    }

    public class Event3
    extends Event1 {
    }

    public class Event2 {
        int fRecipientNumberCounter = 1;
    }

    public class Event1 {
        int fRecipientNumberCounter = 1;
    }
}

