/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIStreamRecord;
import org.eclipse.dd.mi.service.command.output.MITargetStreamOutput;

public class CLIMonitorListProcessesInfo
extends MIInfo {
    IProcessInfo[] fProcessList;

    public CLIMonitorListProcessesInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public IProcessInfo[] getProcessList() {
        return this.fProcessList;
    }

    private void parse() {
        ArrayList<ProcessInfo> aList = new ArrayList<ProcessInfo>();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            for (int i = 0; i < oobs.length; ++i) {
                Pattern pattern;
                Matcher matcher;
                MIStreamRecord cons;
                String str;
                if (!(oobs[i] instanceof MITargetStreamOutput) || (str = (cons = (MIStreamRecord)oobs[i]).getString().trim()).length() <= 0 || !(matcher = (pattern = Pattern.compile("(\\d*)\\s(Y|N)\\s*\\d*\\s(Y|N)\\s*\\d*\\s*\\D*\\s*\\d\\s(.*)", 8)).matcher(str)).find()) continue;
                ProcessInfo proc = new ProcessInfo(matcher.group(1), matcher.group(4));
                aList.add(proc);
            }
        }
        this.fProcessList = aList.toArray(new IProcessInfo[aList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public class ProcessInfo
    implements IProcessInfo,
    Comparable<ProcessInfo> {
        int pid;
        String name;

        public ProcessInfo(String pidString, String name) {
            try {
                this.pid = Integer.parseInt(pidString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.name = name;
        }

        public ProcessInfo(int pid, String name) {
            this.pid = pid;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getPid() {
            return this.pid;
        }

        @Override
        public int compareTo(ProcessInfo other) {
            int nameCompare = this.getName().compareTo(other.getName());
            if (nameCompare != 0) {
                return nameCompare;
            }
            return this.getPid() < other.getPid() ? -1 : 1;
        }
    }
}

