/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.wizards;

import java.text.Collator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.wizards.SetVlnvPage;
import org.eclipse.dd.ipxact.editor.ui.wizards.SpiritWizardsMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;
import org.eclipse.wst.xml.ui.internal.wizards.NewModelWizard;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizard;
import org.w3c.dom.Document;

public class NewSPIRITWizard
extends NewModelWizard {
    private static final String DEFAULT_EXTENSION = ".spirit";
    private static final List<?> NO_VLNV_TYPE = Arrays.asList("looseGeneratorInvocation", "generatorChangeList");
    protected static final String[] filePageFilterExtensions = new String[]{"*.spirit"};
    protected NewModelWizard.NewFilePage newFilePage;
    protected SelectVersionPage selectVersionPage;
    protected SelectRootElementPage selectRootElementPage;
    protected SetVlnvPage setVlnvPage;
    protected String cmDocumentErrorMessage;
    protected NewXMLGenerator generator;
    protected SchemaInfo.IpxactVersion wizardVersionHandling;
    protected String uri;
    private boolean vlnvNameSet;

    public NewSPIRITWizard() {
        this.setWindowTitle("Create IP-XACT File");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(XMLWizard.class, (String)"icons/generatexml_wiz.gif"));
        this.generator = new NewXMLGenerator();
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        this.wizardVersionHandling = SchemaInfo.IpxactVersion.V14;
        try {
            this.uri = catalog.resolveURI("http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.4");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.generator.setGrammarURI(this.uri);
    }

    public void addPages() {
        this.newFilePage = new NewModelWizard.NewFilePage((NewModelWizard)this, this.fSelection);
        this.newFilePage.setTitle("IP-XACT File Name");
        this.newFilePage.setDescription("Specify a name for the new IP-XACT file");
        this.newFilePage.defaultName = "NewFile";
        this.newFilePage.defaultFileExtension = DEFAULT_EXTENSION;
        this.newFilePage.filterExtensions = filePageFilterExtensions;
        this.addPage((IWizardPage)this.newFilePage);
        this.selectVersionPage = new SelectVersionPage();
        this.selectVersionPage.setTitle(Messages.Select_Schema_Standard);
        this.selectVersionPage.setDescription(Messages._UI_WIZARD_SELECT_SCHEMA_EXPL);
        this.addPage((IWizardPage)this.selectVersionPage);
        this.selectRootElementPage = new SelectRootElementPage();
        this.selectRootElementPage.setTitle(SpiritWizardsMessages._UI_WIZARD_SELECT_ROOT_HEADING);
        this.selectRootElementPage.setDescription(SpiritWizardsMessages._UI_WIZARD_SELECT_ROOT_EXPL);
        this.addPage((IWizardPage)this.selectRootElementPage);
        this.setVlnvPage = new SetVlnvPage();
        this.setVlnvPage.setTitle("Set VLNV");
        this.setVlnvPage.setDescription("Set the VLNV of the new IP-XACT document");
        this.addPage((IWizardPage)this.setVlnvPage);
    }

    public SchemaInfo.IpxactVersion setVersionHandling() {
        SchemaInfo.IpxactVersion dummy = null;
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (this.wizardVersionHandling.equals((Object)SchemaInfo.IpxactVersion.V14)) {
            try {
                this.uri = catalog.resolveURI("http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.4");
            }
            catch (Exception e) {}
        } else if (this.wizardVersionHandling.equals((Object)SchemaInfo.IpxactVersion.BEFORE_V14)) {
            try {
                this.uri = catalog.resolveURI("http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.2");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.generator.setGrammarURI(this.uri);
        return dummy;
    }

    public IWizardPage getStartingPage() {
        return this.newFilePage;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        WizardPage nextPage = null;
        if (currentPage == this.newFilePage) {
            nextPage = this.selectVersionPage;
        } else if (currentPage == this.selectVersionPage) {
            nextPage = this.selectRootElementPage;
            this.selectVersionPage.isPageComplete();
        } else if (currentPage == this.selectRootElementPage && !NO_VLNV_TYPE.contains(this.generator.getRootElementName())) {
            String vlnvName;
            nextPage = this.setVlnvPage;
            if (!this.vlnvNameSet && (vlnvName = this.setVlnvPage.getVlnvName()).length() == 0 && (vlnvName = this.newFilePage.getFileName()) != null) {
                int pos = vlnvName.lastIndexOf(46);
                if (pos > 0) {
                    vlnvName = vlnvName.substring(0, pos);
                }
                this.setVlnvPage.setVlnvName(vlnvName);
                this.vlnvNameSet = true;
            }
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean result = this.newFilePage.isPageComplete() && this.selectVersionPage.isPageComplete() && this.selectRootElementPage.isPageComplete() && this.setVlnvPage.isPageComplete();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        boolean result;
        block11: {
            result = true;
            super.performFinish();
            String fileName = null;
            SpiritResourceLibrary library = SpiritResourceLibrary.getDefault();
            try {
                library.lockUpdates();
                String[] namespaceErrors = this.generator.getNamespaceInfoErrors();
                if (namespaceErrors != null) {
                    String title = namespaceErrors[0];
                    String message = namespaceErrors[1];
                    result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
                }
                if (!result) break block11;
                fileName = this.newFilePage.getFileName();
                if (new Path(fileName).getFileExtension() == null) {
                    this.newFilePage.setFileName(fileName.concat(DEFAULT_EXTENSION));
                }
                IFile newFile = this.newFilePage.createNewFile();
                String xmlFileName = newFile.getLocation().toOSString();
                this.generator.createXMLDocument(newFile, xmlFileName);
                newFile.refreshLocal(1, null);
                if (this.setVlnvPage.isVlnvSet() && !NO_VLNV_TYPE.contains(this.generator.getRootElementName())) {
                    IStructuredModel model = ModelManagerImpl.getInstance().getModelForEdit(newFile);
                    model.aboutToChangeModel();
                    try {
                        IDOMDocument document = ((IDOMModel)model).getDocument();
                        SpiritDocument sdoc = SpiritDocumentFactory.getFactory().create((Document)document);
                        sdoc.setVlnv(this.setVlnvPage.getVlnv());
                    }
                    finally {
                        model.changedModel();
                    }
                    model.save();
                }
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                BasicNewResourceWizard.selectAndReveal((IResource)newFile, (IWorkbenchWindow)workbenchWindow);
                this.openEditor(newFile);
            }
            catch (Exception e) {
                Logger.logException((String)("Exception completing New XML wizard " + fileName), (Throwable)e);
            }
            finally {
                library.unlockUpdates();
            }
        }
        return result;
    }

    private void openEditor(IFile file) {
        String editorId = null;
        try {
            IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getLocation().toOSString(), file.getContentDescription().getContentType());
            if (editor != null) {
                editorId = editor.getId();
            }
        }
        catch (CoreException e1) {
            return;
        }
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
            }
        }
        catch (PartInitException e) {
            return;
        }
    }

    protected String getDefaultSystemId() {
        String relativePath = "platform:/resource/" + this.newFilePage.getContainerFullPath().toString() + "/dummy";
        return URIHelper.getRelativeURI((String)this.generator.getGrammarURI(), (String)relativePath);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectRootElementPage
    extends WizardPage
    implements SelectionListener {
        protected Combo combo;
        protected Button[] radioButton;
        protected PageBook pageBook;
        protected XSDOptionsPanel xsdOptionsPanel;

        SelectRootElementPage() {
            super("SelectRootElementPage");
        }

        public void createControl(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)containerGroup, "org.eclipse.wst.xml.ui.xmlc0410");
            containerGroup.setLayout((Layout)new GridLayout());
            containerGroup.setLayoutData((Object)new GridData(768));
            this.setControl((Control)containerGroup);
            Label containerLabel = new Label(containerGroup, 0);
            containerLabel.setText(SpiritWizardsMessages._UI_LABEL_ROOT_ELEMENT);
            this.combo = new Combo(containerGroup, 12);
            this.combo.setLayoutData((Object)new GridData(768));
            this.combo.addSelectionListener((SelectionListener)this);
            Group group = new Group(containerGroup, 0);
            group.setText(SpiritWizardsMessages._UI_WIZARD_CONTENT_OPTIONS);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.radioButton = new Button[4];
            this.radioButton[0] = new Button((Composite)group, 32);
            this.radioButton[0].setText(SpiritWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ATTRIBUTES);
            this.radioButton[0].setLayoutData((Object)new GridData(768));
            this.radioButton[0].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[0], "org.eclipse.wst.xml.ui.xmlc0441");
            this.radioButton[1] = new Button((Composite)group, 32);
            this.radioButton[1].setText(SpiritWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ELEMENTS);
            this.radioButton[1].setLayoutData((Object)new GridData(768));
            this.radioButton[1].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[1], "org.eclipse.wst.xml.ui.xmlc0442");
            this.radioButton[2] = new Button((Composite)group, 32);
            this.radioButton[2].setText(SpiritWizardsMessages._UI_WIZARD_CREATE_FIRST_CHOICE);
            this.radioButton[2].setLayoutData((Object)new GridData(768));
            this.radioButton[2].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[2], "org.eclipse.wst.xml.ui.xmlc0443");
            this.radioButton[3] = new Button((Composite)group, 32);
            this.radioButton[3].setText(SpiritWizardsMessages._UI_WIZARD_FILL_ELEMENTS_AND_ATTRIBUTES);
            this.radioButton[3].setLayoutData((Object)new GridData(768));
            this.radioButton[3].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[3], "org.eclipse.wst.xml.ui.xmlc0444");
            this.pageBook = new PageBook(containerGroup, 0);
            this.pageBook.setLayoutData((Object)new GridData(1808));
            this.xsdOptionsPanel = new XSDOptionsPanel(this, (Composite)this.pageBook);
            this.pageBook.showPage((Control)this.xsdOptionsPanel);
        }

        public void widgetSelected(SelectionEvent event) {
            int index = this.combo.getSelectionIndex();
            String rootElementName = index != -1 ? this.combo.getItem(index) : null;
            NewSPIRITWizard.this.generator.setRootElementName(rootElementName);
            this.setPageComplete(this.isPageComplete());
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                try {
                    Assert.isNotNull((Object)NewSPIRITWizard.this.generator.getGrammarURI());
                    if (NewSPIRITWizard.this.generator.getCMDocument() == null) {
                        final String[] errorInfo = new String[2];
                        final CMDocument[] cmdocs = new CMDocument[1];
                        Runnable r = new Runnable(){

                            public void run() {
                                cmdocs[0] = NewXMLGenerator.createCMDocument((String)NewSPIRITWizard.this.generator.getGrammarURI(), (String[])errorInfo);
                            }
                        };
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
                        NewSPIRITWizard.this.generator.setCMDocument(cmdocs[0]);
                        NewSPIRITWizard.this.cmDocumentErrorMessage = errorInfo[1];
                    }
                    if (NewSPIRITWizard.this.generator.getCMDocument() != null && NewSPIRITWizard.this.cmDocumentErrorMessage == null) {
                        CMNamedNodeMap nameNodeMap = NewSPIRITWizard.this.generator.getCMDocument().getElements();
                        Vector<String> nameNodeVector = new Vector<String>();
                        Iterator iDocTypes = SpiritDocumentFactory.getFactory().documentTypes(NewSPIRITWizard.this.wizardVersionHandling);
                        while (iDocTypes.hasNext()) {
                            String docTypeName = (String)iDocTypes.next();
                            CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.getNamedItem(docTypeName);
                            Object value = cmElementDeclaration.getProperty("Abstract");
                            if (value == Boolean.TRUE) continue;
                            nameNodeVector.add(cmElementDeclaration.getElementName());
                        }
                        Object[] nameNodeArray = nameNodeVector.toArray();
                        if (nameNodeArray.length > 0) {
                            Arrays.sort(nameNodeArray, Collator.getInstance());
                        }
                        String defaultRootName = (String)NewSPIRITWizard.this.generator.getCMDocument().getProperty("http://org.eclipse.wst/cm/properties/defaultRootName");
                        int defaultRootIndex = -1;
                        this.combo.removeAll();
                        for (int i = 0; i < nameNodeArray.length; ++i) {
                            String elementName = (String)nameNodeArray[i];
                            this.combo.add(elementName);
                            if (defaultRootName == null || !defaultRootName.equals(elementName)) continue;
                            defaultRootIndex = i;
                        }
                        if (nameNodeArray.length > 0) {
                            defaultRootIndex = defaultRootIndex != -1 ? defaultRootIndex : 0;
                            this.combo.select(defaultRootIndex);
                            NewSPIRITWizard.this.generator.setRootElementName(this.combo.getItem(defaultRootIndex));
                        }
                    }
                    if (NewSPIRITWizard.this.generator.getGrammarURI().endsWith("xsd")) {
                        this.pageBook.showPage((Control)this.xsdOptionsPanel);
                        NewSPIRITWizard.this.generator.setDefaultSystemId(NewSPIRITWizard.this.getDefaultSystemId());
                        NewSPIRITWizard.this.generator.createNamespaceInfoList();
                        for (int i = 0; i < NewSPIRITWizard.this.generator.namespaceInfoList.size(); ++i) {
                            NamespaceInfo nsinfo = (NamespaceInfo)NewSPIRITWizard.this.generator.namespaceInfoList.get(i);
                            if (nsinfo.prefix != null && nsinfo.prefix.trim().length() != 0 || nsinfo.uri == null || nsinfo.uri.trim().length() == 0) continue;
                            nsinfo.prefix = this.getDefaultPrefix(NewSPIRITWizard.this.generator.namespaceInfoList);
                        }
                        this.xsdOptionsPanel.setNamespaceInfoList(NewSPIRITWizard.this.generator.namespaceInfoList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateErrorMessage();
            }
        }

        private String getDefaultPrefix(List<?> nsInfoList) {
            String defaultPrefix = "p";
            if (nsInfoList == null) {
                return defaultPrefix;
            }
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < nsInfoList.size(); ++i) {
                NamespaceInfo nsinfo = (NamespaceInfo)nsInfoList.get(i);
                if (nsinfo.prefix == null) continue;
                v.addElement(nsinfo.prefix);
            }
            if (v.contains(defaultPrefix)) {
                String s = defaultPrefix;
                int j = 0;
                while (v.contains(s)) {
                    s = defaultPrefix + Integer.toString(j);
                    ++j;
                }
                return s;
            }
            return defaultPrefix;
        }

        public boolean isPageComplete() {
            boolean complete;
            boolean bl = complete = NewSPIRITWizard.this.generator.getRootElementName() != null && NewSPIRITWizard.this.generator.getRootElementName().length() > 0 && this.getErrorMessage() == null;
            if (complete) {
                int buildPolicy = 0;
                if (this.radioButton[0].getSelection()) {
                    buildPolicy |= 1;
                }
                if (this.radioButton[1].getSelection()) {
                    buildPolicy |= 2;
                }
                if (this.radioButton[2].getSelection()) {
                    buildPolicy = buildPolicy | 4 | 0x10;
                }
                if (this.radioButton[3].getSelection()) {
                    buildPolicy |= 8;
                }
                NewSPIRITWizard.this.generator.setBuildPolicy(buildPolicy);
            }
            return complete;
        }

        private String computeErrorMessage() {
            String errorMessage = null;
            if (NewSPIRITWizard.this.cmDocumentErrorMessage != null) {
                errorMessage = NewSPIRITWizard.this.cmDocumentErrorMessage;
            } else if (NewSPIRITWizard.this.generator.getRootElementName() == null || NewSPIRITWizard.this.generator.getRootElementName().length() == 0) {
                errorMessage = SpiritWizardsMessages._ERROR_ROOT_ELEMENT_MUST_BE_SPECIFIED;
            }
            return errorMessage;
        }

        private void updateErrorMessage() {
            String errorMessage = this.computeErrorMessage();
            if (errorMessage == null && this.xsdOptionsPanel.isVisible()) {
                errorMessage = this.xsdOptionsPanel.computeErrorMessage();
            }
            this.setErrorMessage(errorMessage);
            this.setPageComplete(this.isPageComplete());
        }
    }

    class SelectVersionPage
    extends WizardPage {
        protected Combo versionCombo;
        protected Label versionLabel;

        SelectVersionPage() {
            super("SelectVersionPage");
        }

        public void createControl(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            containerGroup.setLayout((Layout)new GridLayout());
            containerGroup.setLayoutData((Object)new GridData(768));
            this.setControl((Control)containerGroup);
            this.versionLabel = new Label(containerGroup, 0);
            this.versionLabel.setText(Messages.Select_Schema_Standard);
            this.versionCombo = new Combo(containerGroup, 4);
            this.versionCombo.setText(Messages.IpxactV14);
            this.versionCombo.add(Messages.IpxactV14);
            this.versionCombo.add(Messages.IpxactV12);
            this.versionCombo.setLayoutData((Object)new GridData(768));
        }

        public boolean isPageComplete() {
            boolean complete = true;
            ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
            if (this.versionCombo.getText().equals(Messages.IpxactV14)) {
                NewSPIRITWizard.this.wizardVersionHandling = SchemaInfo.IpxactVersion.V14;
                try {
                    NewSPIRITWizard.this.uri = catalog.resolveURI("http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.4");
                }
                catch (Exception e) {}
            } else if (this.versionCombo.getText().equals(Messages.IpxactV12)) {
                NewSPIRITWizard.this.wizardVersionHandling = SchemaInfo.IpxactVersion.BEFORE_V14;
                try {
                    NewSPIRITWizard.this.uri = catalog.resolveURI("http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.2");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NewSPIRITWizard.this.generator.setGrammarURI(NewSPIRITWizard.this.uri);
            return complete;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XSDOptionsPanel
    extends Composite {
        protected String errorMessage;
        protected SelectRootElementPage parentPage;
        protected CommonEditNamespacesDialog editNamespaces;

        public XSDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.errorMessage = null;
            this.parentPage = parentPage;
            this.setLayout((Layout)this.createOptionsPanelLayout());
            this.setLayoutData(new GridData(1808));
            Composite co = new Composite((Composite)this, 0);
            co.setLayout((Layout)new GridLayout());
            if (NewSPIRITWizard.this.newFilePage != null && NewSPIRITWizard.this.newFilePage.getContainerFullPath() != null) {
                String resourceURI = "platform:/resource" + NewSPIRITWizard.this.newFilePage.getContainerFullPath().toString() + "/dummy";
                String resolvedPath = URIHelper.normalize((String)resourceURI, null, null);
                if (resolvedPath.startsWith("file:/")) {
                    resolvedPath = resolvedPath.substring(6);
                }
                String tableTitle = SpiritWizardsMessages._UI_LABEL_NAMESPACE_INFORMATION;
                this.editNamespaces = new CommonEditNamespacesDialog(co, (IPath)new Path(resolvedPath), tableTitle, true, true);
            }
        }

        private GridLayout createOptionsPanelLayout() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            return gridLayout;
        }

        void setNamespaceInfoList(List<?> list) {
            this.editNamespaces.setNamespaceInfoList(list);
            this.editNamespaces.updateErrorMessage(list);
        }

        String computeErrorMessage() {
            return this.errorMessage;
        }
    }
}

