/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.transport;

import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.debug.ui.memory.transport.BufferedMemoryWriter;
import org.eclipse.dd.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.dd.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.dd.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RAWBinaryImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private Properties fProperties;
    private static final int BUFFER_LENGTH = 65536;

    public Control createControl(final Composite parent, IMemoryBlock memBlock, Properties properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                RAWBinaryImporter.this.fProperties.setProperty("File", RAWBinaryImporter.this.fFileText.getText());
                RAWBinaryImporter.this.fProperties.setProperty("Start", RAWBinaryImporter.this.fStartText.getText());
                RAWBinaryImporter.this.fProperties.setProperty("ScrollToStart", RAWBinaryImporter.this.fScrollToStart.toString());
                RAWBinaryImporter.this.fStartAddress = RAWBinaryImporter.this.getStartAddress();
                RAWBinaryImporter.this.fInputFile = RAWBinaryImporter.this.getFile();
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label labelStartText = new Label(composite, 0);
        labelStartText.setText("Restore to address: ");
        this.fStartText = new Text(composite, 0);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)labelStartText);
        data.width = 100;
        this.fStartText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 0);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText("File name: ");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        this.fFileText.setText(properties.getProperty("File", ""));
        this.fScrollToStart = new Boolean(properties.getProperty("ScrollToStart", "true"));
        try {
            BigInteger startAddress = null;
            startAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
            if (properties.getProperty("Start") != null) {
                this.fStartText.setText(properties.getProperty("Start"));
            } else {
                this.fStartText.setText("0x" + startAddress.toString(16));
            }
        }
        catch (Exception e) {
            MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText("Choose memory import file");
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{"All Files"});
                dialog.setFileName(RAWBinaryImporter.this.fFileText.getText());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    RAWBinaryImporter.this.fFileText.setText(dialog.getFilterPath() + File.separator + filename);
                }
                RAWBinaryImporter.this.validate();
            }
        });
        this.fStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    RAWBinaryImporter.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                RAWBinaryImporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                RAWBinaryImporter.this.validate();
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RAWBinaryImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText("Scroll to File Start Address");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RAWBinaryImporter.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getStartAddress();
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText());
    }

    public String getId() {
        return "rawbinary";
    }

    public String getName() {
        return "RAW Binary";
    }

    public void importMemory() {
        Job job = new Job("Memory Import from RAW Binary File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        BufferedMemoryWriter memoryWriter = new BufferedMemoryWriter((IMemoryBlockExtension)RAWBinaryImporter.this.fMemoryBlock, 65536);
                        BigInteger scrollToAddress = null;
                        FileInputStream reader = new FileInputStream(RAWBinaryImporter.this.fInputFile);
                        BigInteger jobs = BigInteger.valueOf(RAWBinaryImporter.this.fInputFile.length());
                        BigInteger factor = BigInteger.ONE;
                        if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                            factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                            jobs = jobs.divide(factor);
                        }
                        byte[] byteValues = new byte[1024];
                        monitor.beginTask("Transferring Data", jobs.intValue());
                        BigInteger jobCount = BigInteger.ZERO;
                        int actualByteCount = reader.read(byteValues);
                        BigInteger recordAddress = RAWBinaryImporter.this.fStartAddress;
                        while (actualByteCount != -1 && !monitor.isCanceled()) {
                            byte[] data = new byte[actualByteCount];
                            for (int i = 0; i < data.length; ++i) {
                                data[i] = byteValues[i];
                            }
                            if (scrollToAddress == null) {
                                scrollToAddress = recordAddress;
                            }
                            BigInteger baseAddress = null;
                            baseAddress = RAWBinaryImporter.this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)RAWBinaryImporter.this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(RAWBinaryImporter.this.fMemoryBlock.getStartAddress());
                            memoryWriter.write(recordAddress.subtract(baseAddress), data);
                            jobCount = jobCount.add(BigInteger.valueOf(actualByteCount));
                            while (jobCount.compareTo(factor) >= 0) {
                                jobCount = jobCount.subtract(factor);
                                monitor.worked(1);
                            }
                            recordAddress.add(BigInteger.valueOf(actualByteCount));
                            actualByteCount = reader.read(byteValues);
                        }
                        memoryWriter.flush();
                        reader.close();
                        monitor.done();
                        if (RAWBinaryImporter.this.fProperties.getProperty("ScrollToStart", "false").equals("true")) {
                            RAWBinaryImporter.this.fParentDialog.scrollRenderings(scrollToAddress);
                        }
                    }
                    catch (Exception e) {
                        MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                    }
                }
                catch (Exception e) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

