/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.ServiceEventWaitor;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class MIRunControlTest
extends BaseTestCase {
    private DsfServicesTracker fServicesTracker;
    private IGDBControl fGDBCtrl;
    private MIRunControl fRunCtrl;
    private IMIProcesses fProcService;
    private IRunControl.IContainerDMContext fContainerDmc;
    private static final String EXEC_PATH = "data/launch/bin/";
    private static final String EXEC_NAME = "MultiThread.exe";
    private static final String SOURCE_NAME = "MultiThread.cc";

    @Before
    public void init() throws Exception {
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.getGDBLaunch().getSession().getId());
        this.fGDBCtrl = (IGDBControl)this.fServicesTracker.getService(IGDBControl.class);
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(this.fGDBCtrl.getContext(), "");
        this.fContainerDmc = procService.createContainerContext(procDmc, "");
        this.fRunCtrl = (MIRunControl)this.fServicesTracker.getService(MIRunControl.class);
        this.fProcService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
    }

    @After
    public void tearDown() {
        this.fServicesTracker.dispose();
    }

    @BeforeClass
    public static void beforeClassMethod() {
        MIRunControlTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/MultiThread.exe");
    }

    @Test
    public void getExecutionContext() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm = new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                MIRunControlTest.this.fRunCtrl.getExecutionContexts((IRunControl.IContainerDMContext)containerDmc, this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IRunControl.IExecutionDMContext[] ctxts = (IRunControl.IExecutionDMContext[])wait.getReturnInfo();
        if (ctxts == null) {
            Assert.fail((String)"Context returned is null. At least one context should have been returned");
        } else {
            if (ctxts.length > 1) {
                Assert.fail((String)"Context returned can not be more than 1. This test case is for single context application.");
            }
            IMIExecutionDMContext dmc = (IMIExecutionDMContext)ctxts[0];
            Assert.assertEquals((Object)1, (Object)dmc.getThreadId());
        }
        wait.waitReset();
    }

    @Test
    public void getExecutionContexts() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRunControl.IExecutionDMContext[]> rmExecutionCtxts = new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        ServiceEventWaitor<IRunControl.IStartedDMEvent> startedEventWaitor = new ServiceEventWaitor<IRunControl.IStartedDMEvent>(this.getGDBLaunch().getSession(), IRunControl.IStartedDMEvent.class);
        try {
            SyncUtil.SyncRunToLine((IRunControl.IExecutionDMContext)this.fContainerDmc, SOURCE_NAME, "22", true);
        }
        catch (Throwable t) {
            Assert.fail((String)("Exception in SyncUtil.SyncRunToLine: " + t.getMessage()));
        }
        IRunControl.IStartedDMEvent startedEvent = null;
        try {
            startedEvent = startedEventWaitor.waitForEvent(1000);
        }
        catch (Exception e) {
            Assert.fail((String)"Timeout waiting for Thread create event");
            return;
        }
        if (((IMIExecutionDMContext)startedEvent.getDMContext()).getThreadId() != 2) {
            Assert.fail((String)("Thread create event has failed expected thread id 2 but got " + ((IMIExecutionDMContext)startedEvent.getDMContext()).getThreadId()));
        }
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rmExecutionCtxts){
            final /* synthetic */ DataRequestMonitor val$rmExecutionCtxts;
            {
                this.val$rmExecutionCtxts = dataRequestMonitor;
            }

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                MIRunControlTest.this.fRunCtrl.getExecutionContexts((IRunControl.IContainerDMContext)containerDmc, this.val$rmExecutionCtxts);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        IRunControl.IExecutionDMContext[] data = (IRunControl.IExecutionDMContext[])rmExecutionCtxts.getData();
        if (data == null) {
            Assert.fail((String)"No context returned. 2 Contexts with id 1 & 2 should have been returned");
        } else {
            Assert.assertTrue((data.length == 2 ? 1 : 0) != 0);
            IMIExecutionDMContext dmc1 = (IMIExecutionDMContext)data[0];
            IMIExecutionDMContext dmc2 = (IMIExecutionDMContext)data[1];
            Assert.assertTrue((dmc1.getThreadId() == 2 && dmc2.getThreadId() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void getModelDataForThread() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRunControl.IExecutionDMData> rm = new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                MIRunControlTest.this.fRunCtrl.getExecutionData((IRunControl.IExecutionDMContext)MIRunControlTest.this.fRunCtrl.createMIExecutionContext((IRunControl.IContainerDMContext)containerDmc, 1), this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IRunControl.IExecutionDMData data = (IRunControl.IExecutionDMData)rm.getData();
        if (data == null) {
            Assert.fail((String)"No data returned.");
        } else {
            Assert.assertTrue((String)" State change reason for a normal execution should be USER_REQUEST.", (IRunControl.StateChangeReason.USER_REQUEST == data.getStateChangeReason() ? 1 : 0) != 0);
        }
    }

    @Test
    public void getModelDataForThreadWhenStep() throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        final MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER);
        DataRequestMonitor<IRunControl.IExecutionDMData> rm = new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                MIRunControlTest.this.fRunCtrl.getExecutionData((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IRunControl.IExecutionDMData data = (IRunControl.IExecutionDMData)rm.getData();
        if (data == null) {
            Assert.fail((String)"No data Returned.");
        } else {
            Assert.assertTrue((String)"getModelData for ExecutionDMC in case of step should be STEP.", (IRunControl.StateChangeReason.STEP == data.getStateChangeReason() ? 1 : 0) != 0);
        }
    }

    @Test
    public void getModelDataForThreadWhenBreakpoint() throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        SyncUtil.SyncAddBreakpoint("MultiThread.cc:21", false);
        final MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        DataRequestMonitor<IRunControl.IExecutionDMData> rm = new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                MIRunControlTest.this.fRunCtrl.getExecutionData((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IRunControl.IExecutionDMData data = (IRunControl.IExecutionDMData)rm.getData();
        if (data == null) {
            Assert.fail((String)"No data Returned.");
        } else {
            Assert.assertTrue((String)("getModelData for an Execution DMC when a breakpoint is hit is not BREAKPOINT and is " + data.getStateChangeReason()), (IRunControl.StateChangeReason.BREAKPOINT == data.getStateChangeReason() ? 1 : 0) != 0);
        }
    }

    @Test
    public void getModelDataForContainer() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRunControl.IExecutionDMData> rm = new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                MIRunControlTest.this.fRunCtrl.getExecutionData((IRunControl.IExecutionDMContext)MIRunControlTest.this.fContainerDmc, this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IRunControl.IExecutionDMData data = (IRunControl.IExecutionDMData)rm.getData();
        if (data == null) {
            Assert.fail((String)"No data returned.");
        } else {
            Assert.assertTrue((String)" State change reason for a normal execution should be USER_REQUEST.", (IRunControl.StateChangeReason.USER_REQUEST == data.getStateChangeReason() ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void getExecutionContextsForInvalidContainerDMC() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm = new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                MIRunControlTest.this.fRunCtrl.getExecutionContexts(MIRunControlTest.this.fContainerDmc, this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (!wait.isOK() ? 1 : 0) != 0);
        IStatus status = rm.getStatus();
        Assert.assertEquals((String)"Error message for invalid container", (Object)4, (Object)status.getSeverity());
    }

    @Test
    public void cacheAfterContainerSuspendEvent() throws InterruptedException {
        try {
            SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER);
        }
        catch (Throwable e) {
            Assert.fail((String)("Exception in SyncUtil.SyncStep: " + e.getMessage()));
        }
    }

    @Test
    public void resume() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<MIInfo> rm = new DataRequestMonitor<MIInfo>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                wait.waitFinished(this.getStatus());
            }
        };
        ServiceEventWaitor<IRunControl.IResumedDMEvent> eventWaitor = new ServiceEventWaitor<IRunControl.IResumedDMEvent>(this.getGDBLaunch().getSession(), IRunControl.IResumedDMEvent.class);
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                MIRunControlTest.this.fRunCtrl.resume((IRunControl.IExecutionDMContext)containerDmc, (RequestMonitor)this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        try {
            eventWaitor.waitForEvent(0);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception raised:: " + e.getMessage()));
            e.printStackTrace();
            return;
        }
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fRunCtrl.getExecutor().submit(new Runnable(){

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                wait.setReturnInfo(MIRunControlTest.this.fRunCtrl.isSuspended((IRunControl.IExecutionDMContext)containerDmc));
                wait.waitFinished();
            }
        });
        wait.waitUntilDone(0);
        Assert.assertFalse((String)"Target is suspended. It should have been running", (boolean)((Boolean)wait.getReturnInfo()));
        wait.waitReset();
    }

    @Test
    public void resumeContainerContext() throws InterruptedException {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<MIInfo> rm = new DataRequestMonitor<MIInfo>((Executor)this.fRunCtrl.getExecutor(), null){

            protected void handleCompleted() {
                wait.waitFinished(this.getStatus());
            }
        };
        ServiceEventWaitor<IRunControl.IResumedDMEvent> eventWaitor = new ServiceEventWaitor<IRunControl.IResumedDMEvent>(this.getGDBLaunch().getSession(), IRunControl.IResumedDMEvent.class);
        this.fRunCtrl.getExecutor().submit(new Runnable((DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
            }

            public void run() {
                MIRunControlTest.this.fRunCtrl.resume((IRunControl.IExecutionDMContext)MIRunControlTest.this.fContainerDmc, (RequestMonitor)this.val$rm);
            }
        });
        wait.waitUntilDone(0);
        try {
            eventWaitor.waitForEvent(0);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception raised:: " + e.getMessage()));
            e.printStackTrace();
            return;
        }
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        wait.waitReset();
        this.fRunCtrl.getExecutor().submit(new Runnable(){

            public void run() {
                String pid = "";
                IProcesses.IProcessDMContext procDmc = MIRunControlTest.this.fProcService.createProcessContext(MIRunControlTest.this.fGDBCtrl.getContext(), pid);
                IMIContainerDMContext containerDmc = MIRunControlTest.this.fProcService.createContainerContext(procDmc, pid);
                wait.setReturnInfo(MIRunControlTest.this.fRunCtrl.isSuspended((IRunControl.IExecutionDMContext)containerDmc));
                wait.waitFinished();
            }
        });
        wait.waitUntilDone(0);
        Assert.assertFalse((String)"Target is suspended. It should have been running", (boolean)((Boolean)wait.getReturnInfo()));
        wait.waitReset();
    }
}

