/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.HierarchyRef;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.MemoryMap;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritComponentDocument
extends SpiritDocument {
    public static final String DOCUMENT_TYPE = "component";

    public SpiritComponentDocument(Document xmlDoc) {
        super(xmlDoc);
    }

    @Override
    public String getRootTagName() {
        return DOCUMENT_TYPE;
    }

    public static String getRootTag() {
        return DOCUMENT_TYPE;
    }

    @Override
    public String[] attributeValueSuggestions(Node node, String attribute) {
        ArrayList<String> resultsList = new ArrayList<String>();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node != null) {
            SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)node);
            if (node.getLocalName().equals("addressSpaceRef") && attribute.equals("addressSpaceRef")) {
                NodeList addressSpaces = spiritNode.getNodeList("addressSpace");
                resultsList = spiritNode.getTextList(addressSpaces, "name", resultsList);
            } else if (node.getLocalName().equals("memoryMapRef") && attribute.equals("memoryMapRef")) {
                NodeList memoryMaps = spiritNode.getNodeList("memoryMap");
                resultsList = spiritNode.getTextList(memoryMaps, "name", resultsList);
            }
        }
        if (resultsList.size() == 0) {
            return super.attributeValueSuggestions(node, attribute);
        }
        String[] dummy = new String[]{};
        return resultsList.toArray(dummy);
    }

    @Override
    public String[] elementValueSuggestions(Node node, String name) {
        ArrayList<String> resultsList = new ArrayList<String>();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node != null) {
            SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)node);
            String signalOrPort_capital = SchemaInfo.getSpiritString("Signal", this.getDocumentElement().getNamespaceURI());
            String signalOrPort = signalOrPort_capital.toLowerCase();
            if (node.getLocalName().equals(DOCUMENT_TYPE + signalOrPort_capital + "Name")) {
                NodeList signals = spiritNode.getNodeList(signalOrPort);
                resultsList = spiritNode.getTextList(signals, "name", resultsList);
            } else if (node.getLocalName().equals("bus" + signalOrPort_capital + "Name")) {
                Node cnode = node.getParentNode().getParentNode();
                String nodename = cnode.getLocalName();
                while (!nodename.equals("busType")) {
                    cnode = cnode.getPreviousSibling().getPreviousSibling();
                    nodename = cnode.getLocalName();
                }
                SpiritNode spiritcNode = SpiritNode.createSpiritNode((Element)cnode);
                Vlnv vlnv = spiritcNode.getVlnvAttribute();
                NodeList signalNodes = spiritNode.getNodeList(vlnv, signalOrPort);
                resultsList = spiritNode.getTextList(signalNodes, "logicalName", resultsList);
            } else if (node.getLocalName().equals("busInterfaceRef")) {
                NodeList busInterfaces = spiritNode.getNodeList("busInterface");
                resultsList = spiritNode.getTextList(busInterfaces, "name", resultsList);
            }
        }
        if (resultsList.size() == 0) {
            return super.elementValueSuggestions(node, name);
        }
        String[] dummy = new String[]{};
        return resultsList.toArray(dummy);
    }

    public BusInterface getBusInterface(String name) {
        return this.getNamedSubitem("busInterface", name, BusInterface.class);
    }

    public List<BusInterface> getBusInterfaces() {
        return this.getDescendants("busInterface", BusInterface.class);
    }

    public SpiritNode getAddressSpace(String name) {
        return this.getNamedSubitem("addressSpace", name, SpiritNode.class);
    }

    public MemoryMap getMemoryMap(String name) {
        return this.getNamedSubitem("memoryMap", name, MemoryMap.class);
    }

    public SpiritNode getModel() {
        return this.getUniqueChildElement("model", SpiritNode.class);
    }

    public List<HierarchyRef> getHierarchyRefs() {
        return this.getDescendants("hierarchyRef", HierarchyRef.class);
    }
}

