/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.dm;

import java.util.concurrent.ExecutionException;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMContextsTest {
    TestDsfExecutor fExecutor;
    DsfSession fSession;
    BaseContextType[] c = new BaseContextType[8];

    @Before
    public void startExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                DMContextsTest.this.fSession = DsfSession.startSession((DsfExecutor)DMContextsTest.this.fExecutor, (String)"DMContextsTest");
            }
        }).get();
        this.c[7] = new SecondType(new IDMContext[0], 7);
        this.c[6] = new ThirdType(new IDMContext[]{this.c[7]}, 6);
        this.c[5] = new ThirdType(new IDMContext[]{this.c[6]}, 5);
        this.c[4] = new SecondType(new IDMContext[0], 4);
        this.c[3] = new FirstType(new IDMContext[]{this.c[4]}, 3);
        this.c[2] = new ThirdType(new IDMContext[]{this.c[3]}, 2);
        this.c[1] = new FirstType(new IDMContext[]{this.c[2], this.c[6]}, 1);
        this.c[0] = new FirstType(new IDMContext[]{this.c[1], this.c[5]}, 0);
    }

    @After
    public void shutdownExecutor() throws ExecutionException, InterruptedException {
        DsfSession.endSession((DsfSession)this.fSession);
        this.fSession = null;
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                DMContextsTest.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void testClosestAncestor() throws Throwable {
        BaseContextType ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[0], FirstType.class);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestor != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got ancestor " + ancestor.fId + " intead of 1"), (ancestor.fId == 0 ? 1 : 0) != 0);
        ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[0], SecondType.class);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestor != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got ancestor " + ancestor.fId + " intead of 8"), (ancestor.fId == 7 ? 1 : 0) != 0);
        ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[0], ThirdType.class);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestor != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got ancestor " + ancestor.fId + " intead of 6"), (ancestor.fId == 5 ? 1 : 0) != 0);
        ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[1], SecondType.class);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestor != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got ancestor " + ancestor.fId + " intead of 8"), (ancestor.fId == 7 ? 1 : 0) != 0);
        ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[1], ThirdType.class);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestor != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got ancestor " + ancestor.fId + " intead of 3"), (ancestor.fId == 2 ? 1 : 0) != 0);
        ancestor = (BaseContextType)DMContexts.getAncestorOfType((IDMContext)this.c[5], FirstType.class);
        Assert.assertTrue((String)"Got unexpected non-null ancestor", (ancestor == null ? 1 : 0) != 0);
    }

    @Test
    public void testAllClosestAncestors() throws Throwable {
        this.checkAncestors(this.c[0], BaseContextType.class, new int[]{0, 1, 5, 2, 6, 3, 7, 4});
        this.checkAncestors(this.c[0], FirstType.class, new int[]{0, 1, 3});
        this.checkAncestors(this.c[0], SecondType.class, new int[]{7, 4});
        this.checkAncestors(this.c[0], ThirdType.class, new int[]{5, 2, 6});
        UnknownType[] exprAncestors = (UnknownType[])DMContexts.getAllAncestorsOfType((IDMContext)this.c[0], UnknownType.class);
        Assert.assertTrue((String)"Got unexpected non-null ancestor list", (exprAncestors == null ? 1 : 0) != 0);
    }

    private <V extends IDMContext> void checkAncestors(BaseContextType ctx, Class<V> type, int[] expected) {
        BaseContextType[] ancestors = (BaseContextType[])DMContexts.getAllAncestorsOfType((IDMContext)ctx, type);
        Assert.assertTrue((String)"Got unexpected null ancestor", (ancestors != null ? 1 : 0) != 0);
        String ancestorsStr = "";
        String expectedStr = "";
        for (int k = 0; k < ancestors.length; ++k) {
            ancestorsStr = ancestorsStr + ancestors[k].fId + ",";
        }
        for (int j = 0; j < expected.length; ++j) {
            expectedStr = expectedStr + expected[j] + ",";
        }
        Assert.assertTrue((String)("Got " + ancestorsStr + " instead of " + expectedStr), (ancestors.length == expected.length ? 1 : 0) != 0);
        for (int i = 0; i < expected.length; ++i) {
            if (ancestors[i].fId == expected[i]) continue;
            Assert.assertTrue((String)("Got " + ancestorsStr + " instead of " + expectedStr), (boolean)false);
        }
    }

    private static interface UnknownType
    extends IDMContext {
    }

    private class ThirdType
    extends BaseContextType {
        public ThirdType(IDMContext[] parents, int id) {
            super(parents, id);
        }
    }

    private class SecondType
    extends BaseContextType {
        public SecondType(IDMContext[] parents, int id) {
            super(parents, id);
        }
    }

    private class FirstType
    extends BaseContextType {
        public FirstType(IDMContext[] parents, int id) {
            super(parents, id);
        }
    }

    private class BaseContextType
    extends AbstractDMContext {
        final int fId;

        public BaseContextType(IDMContext[] parents, int id) {
            super(DMContextsTest.this.fSession.getId(), parents);
            this.fId = id;
        }

        public String toString() {
            return this.baseToString() + ".[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((BaseContextType)((Object)obj)).fId == this.fId;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fId;
        }
    }
}

