/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIRunControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl_7_0
extends MIRunControl {
    private IGDBBackend fGdb;
    private IMIProcesses fProcService;

    public GDBRunControl_7_0(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                GDBRunControl_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fProcService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        this.register(new String[]{IRunControl.class.getName(), MIRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, int threadId) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = this.fProcService.createThreadContext(procDmc, Integer.toString(threadId));
        }
        return this.fProcService.createExecutionContext(container, threadDmc, Integer.toString(threadId));
    }

    public void suspend(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    GDBRunControl_7_0.this.fGdb.interrupt();
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Context cannot be suspended.", null));
                }
                rm.done();
            }
        });
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fProcService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    IRunControl.IExecutionDMContext[] execDmcs = (IRunControl.IExecutionDMContext[])this.getData();
                    rm.setData((Object)execDmcs);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }
}

