/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.actions;

import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.dd.dsf.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class ProcessInfo
implements IProcessInfo,
Comparable<ProcessInfo> {
    private final int pid;
    private final String name;

    public ProcessInfo(String pidString, String name) {
        int tmpPid = 0;
        try {
            tmpPid = Integer.parseInt(pidString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.pid = tmpPid;
        this.name = name;
    }

    public ProcessInfo(int pid, String name) {
        this.pid = pid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getPid() {
        return this.pid;
    }

    @Override
    public int compareTo(ProcessInfo other) {
        int nameCompare = this.getName().compareTo(other.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        return this.getPid() < other.getPid() ? -1 : 1;
    }
}

