/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.RegisterBitFieldCellModifier;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterBitFieldVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementMementoProvider {
    private SyncRegisterDataAccess fSyncRegisterDataAccess = null;
    protected IWatchExpressionFactoryAdapter2 fBitFieldExpressionFactory = null;
    private final IFormattedValuePreferenceStore fFormattedPrefStore;
    private final String MEMENTO_NAME = "BITFIELD_MEMENTO_NAME";

    public RegisterBitFieldVMNode(IFormattedValuePreferenceStore prefStore, AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess access) {
        super(provider, session, IRegisters.IBitFieldDMContext.class);
        this.fSyncRegisterDataAccess = access;
        this.fFormattedPrefStore = prefStore;
    }

    public String toString() {
        return "RegisterBitFieldVMNode(" + this.getSession().getId() + ")";
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedPrefStore;
    }

    public SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IWatchExpressionFactoryAdapter2 getWatchExpressionFactory() {
        if (this.fBitFieldExpressionFactory == null) {
            this.fBitFieldExpressionFactory = new BitFieldExpressionFactory();
        }
        return this.fBitFieldExpressionFactory;
    }

    private void updateFormattedRegisterValue(final ILabelUpdate update, final int labelIndex, final IRegisters.IBitFieldDMContext dmc, final IRegisters.IBitFieldDMData data) {
        final IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        regService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    RegisterBitFieldVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "HEX.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        RegisterBitFieldVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                final IFormattedValues.FormattedValueDMContext valueDmc = regService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                RegisterBitFieldVMNode.this.getDMVMProvider().getModelData((IVMNode)RegisterBitFieldVMNode.this, (IViewerUpdate)update, (IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)RegisterBitFieldVMNode.this.getSession().getExecutor(), (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (!this.isSuccess()) {
                            if (this.getStatus().getCode() == 10001) {
                                update.setLabel("...", labelIndex);
                            } else {
                                update.setLabel("Error: " + this.getStatus().getMessage(), labelIndex);
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], labelIndex);
                            update.done();
                            return;
                        }
                        IRegisters.IMnemonic mnemonic = data.getCurrentMnemonicValue();
                        if (mnemonic != null) {
                            String mnemstr = mnemonic.getLongName() + " - " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue();
                            update.setLabel(mnemstr, labelIndex);
                        } else {
                            update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        }
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], labelIndex);
                        IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)RegisterBitFieldVMNode.this.getDMVMProvider().getArchivedModelData((IVMNode)RegisterBitFieldVMNode.this, (IViewerUpdate)update, (IDMContext)valueDmc);
                        if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue())) {
                            update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), labelIndex);
                        }
                        update.done();
                    }
                }, RegisterBitFieldVMNode.this.getExecutor());
            }
        });
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    RegisterBitFieldVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
            if (regService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            final IRegisters.IBitFieldDMContext dmc = (IRegisters.IBitFieldDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IBitFieldDMContext.class);
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)regService, (IDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    int idx;
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        String[] localColumns = update.getColumnIds();
                        if (localColumns == null) {
                            localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                        }
                        for (int idx2 = 0; idx2 < localColumns.length; ++idx2) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx2])) {
                                update.setLabel("Unknown name", idx2);
                                update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx2])) {
                                if (this.getStatus().getCode() == 10001) {
                                    update.setLabel("...", idx2);
                                } else {
                                    update.setLabel("Error: " + this.getStatus().getMessage(), idx2);
                                }
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx2])) {
                                update.setLabel("...", idx2);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx2);
                        }
                        update.done();
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getName(), idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            IRegisters.IBitFieldDMData data = (IRegisters.IBitFieldDMData)this.getData();
                            String typeStr = "Unsigned";
                            String ReadAttrStr = "ReadNone";
                            String WriteAddrStr = "WriteNone";
                            if (data.isReadOnce()) {
                                ReadAttrStr = "ReadOnce";
                            } else if (data.isReadable()) {
                                ReadAttrStr = "Readable";
                            }
                            if (data.isReadOnce()) {
                                WriteAddrStr = "WriteOnce";
                            } else if (data.isReadable()) {
                                WriteAddrStr = "Writeable";
                            }
                            typeStr = typeStr + " - " + ReadAttrStr + "/" + WriteAddrStr;
                            update.setLabel(typeStr, idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getDescription(), idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) {
                            IVMContext vmc = (IVMContext)update.getElement();
                            IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                            if (expression != null) {
                                update.setLabel(expression.getExpressionText(), idx);
                            } else {
                                update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getName(), idx);
                            }
                        }
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                                RegisterBitFieldVMNode.this.updateFormattedRegisterValue(update, idx, dmc, (IRegisters.IBitFieldDMData)this.getData());
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        }
                    }
                }
            }, this.getExecutor());
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterDMContext.class);
        if (regDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        regService.getBitFields((IDMContext)regDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IBitFieldDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            protected void handleFailure() {
                RegisterBitFieldVMNode.this.handleFailedUpdate((IViewerUpdate)update);
            }

            protected void handleSuccess() {
                RegisterBitFieldVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new BitFieldVMC(dmc);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegisterChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        if (e instanceof IRegisters.IBitFieldChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegisterChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (e instanceof IRegisters.IBitFieldChangedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IRegisters.IBitFieldChangedDMEvent)e).getDMContext()), 2048);
        }
        rm.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            IRegisters.IBitFieldDMData bitFieldData = this.getSyncRegisterDataAccess().readBitField(element);
            if (bitFieldData != null && bitFieldData.isWriteable()) {
                IRegisters.IMnemonic[] mnemonics = bitFieldData.getMnemonics();
                if (mnemonics != null && mnemonics.length != 0) {
                    String[] StringValues = new String[mnemonics.length];
                    int idx = 0;
                    for (IRegisters.IMnemonic mnemonic : mnemonics) {
                        StringValues[idx++] = mnemonic.getLongName();
                    }
                    return new ComboBoxCellEditor(parent, StringValues);
                }
                return new TextCellEditor(parent);
            }
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        IRegisters.IBitFieldDMData bitFieldData = this.getSyncRegisterDataAccess().readBitField(element);
        if (bitFieldData != null && bitFieldData.isWriteable()) {
            IRegisters.IMnemonic[] mnemonics = bitFieldData.getMnemonics();
            if (mnemonics != null && mnemonics.length != 0) {
                return new RegisterBitFieldCellModifier((AbstractCachingVMProvider)this.getDMVMProvider(), this.fFormattedPrefStore, RegisterBitFieldCellModifier.BitFieldEditorStyle.BITFIELDCOMBO, this.getSyncRegisterDataAccess());
            }
            return new RegisterBitFieldCellModifier((AbstractCachingVMProvider)this.getDMVMProvider(), this.fFormattedPrefStore, RegisterBitFieldCellModifier.BitFieldEditorStyle.BITFIELDTEXT, this.getSyncRegisterDataAccess());
        }
        return null;
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForBitFieldName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForBitFieldName(String expression) {
        if (expression.startsWith("GRP(")) {
            int startIdx = "GRP(".length();
            int endIdx = expression.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            String remaining = expression.substring(endIdx + 1);
            if (!remaining.startsWith(".REG(")) {
                return null;
            }
            startIdx = ".REG(".length();
            endIdx = remaining.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            if (!(remaining = remaining.substring(endIdx + 1)).startsWith(".BFLD(")) {
                return null;
            }
            startIdx = ".BFLD(".length();
            endIdx = remaining.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            String bitFieldName = remaining.substring(startIdx, endIdx);
            if ((remaining = remaining.substring(endIdx + 1)).length() != 0) {
                return null;
            }
            return bitFieldName.trim();
        }
        return null;
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, final DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final IRegisters.IBitFieldDMContext dmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IBitFieldDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final String bitFieldName = this.parseExpressionForBitFieldName(expression.getExpressionText());
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters registersService = (IRegisters)RegisterBitFieldVMNode.this.getServicesTracker().getService(IRegisters.class);
                    if (registersService != null) {
                        registersService.getBitFieldData(dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                rm.setData((Object)((IRegisters.IBitFieldDMData)this.getData()).getName().equals(bitFieldName));
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(2, "org.eclipse.dd.dsf.debug.ui", 10001, "Register service not available", null));
                        rm.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(2, "org.eclipse.dd.dsf.debug.ui", 10001, "DSF session shut down", null));
            rm.done();
        }
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof BitFieldVMC) {
            ((BitFieldVMC)element).setExpression(expression);
        }
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        if (event instanceof IMemory.IMemoryChangedEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (final IElementCompareRequest request : requests) {
            final String mementoName = request.getMemento().getString("BITFIELD_MEMENTO_NAME");
            final IRegisters.IBitFieldDMContext regDmc = (IRegisters.IBitFieldDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IBitFieldDMContext.class);
            if (regDmc == null || mementoName == null) {
                request.done();
                continue;
            }
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IRegisters regService = (IRegisters)RegisterBitFieldVMNode.this.getServicesTracker().getService(IRegisters.class);
                        if (regService != null) {
                            regService.getBitFieldData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)regService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (this.getStatus().isOK()) {
                                        request.setEqual(mementoName.equals("BitField." + ((IRegisters.IBitFieldDMData)this.getData()).getName()));
                                    }
                                    request.done();
                                }
                            });
                        } else {
                            request.done();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                request.done();
            }
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (final IElementMementoRequest request : requests) {
            final IRegisters.IBitFieldDMContext regDmc = (IRegisters.IBitFieldDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IBitFieldDMContext.class);
            if (regDmc == null) {
                request.done();
                continue;
            }
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IRegisters regService = (IRegisters)RegisterBitFieldVMNode.this.getServicesTracker().getService(IRegisters.class);
                        if (regService != null) {
                            regService.getBitFieldData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)regService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (this.getStatus().isOK()) {
                                        request.getMemento().putString("BITFIELD_MEMENTO_NAME", "BitField." + ((IRegisters.IBitFieldDMData)this.getData()).getName());
                                    }
                                    request.done();
                                }
                            });
                        } else {
                            request.done();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                request.done();
            }
        }
    }

    protected class BitFieldExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected BitFieldExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof BitFieldVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            IRegisters.IRegisterGroupDMData groupData = RegisterBitFieldVMNode.this.getSyncRegisterDataAccess().getRegisterGroupDMData(element);
            IRegisters.IRegisterDMData registerData = RegisterBitFieldVMNode.this.getSyncRegisterDataAccess().getRegisterDMData(element);
            IRegisters.IBitFieldDMData bitFieldData = RegisterBitFieldVMNode.this.getSyncRegisterDataAccess().getBitFieldDMData(element);
            if (groupData != null && registerData != null && bitFieldData != null) {
                StringBuffer exprBuf = new StringBuffer();
                exprBuf.append("GRP( ");
                exprBuf.append(groupData.getName());
                exprBuf.append(" )");
                exprBuf.append(".REG( ");
                exprBuf.append(registerData.getName());
                exprBuf.append(" )");
                exprBuf.append(".BFLD( ");
                exprBuf.append(bitFieldData.getName());
                exprBuf.append(" )");
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class BitFieldVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext {
        private IExpression fExpression;

        public BitFieldVMC(IDMContext dmc) {
            super((AbstractDMVMNode)RegisterBitFieldVMNode.this, dmc);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return RegisterBitFieldVMNode.this.fFormattedPrefStore;
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterBitFieldVMNode.this.getWatchExpressionFactory();
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof BitFieldVMC && super.equals(other)) {
                BitFieldVMC otherBitField = (BitFieldVMC)other;
                return otherBitField.fExpression == null && this.fExpression == null || otherBitField.fExpression != null && otherBitField.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }
    }
}

