/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceRange;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTag;

public class CSourceTag
implements ISourceTag {
    private ISourceReference fReference;
    private int fType;

    public CSourceTag(ISourceReference element, int elementType) {
        this.fReference = element;
        this.fType = elementType;
    }

    public ISourceRange getFullRange() {
        try {
            return new CSourceRange(this.fReference.getSourceRange());
        }
        catch (CModelException cModelException) {
            return new NullRange();
        }
    }

    public String getName() {
        return ((ICElement)this.fReference).getElementName();
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public ISourceRange getRangeOfIdentifier() {
        try {
            return new CIdentifierRange(this.fReference.getSourceRange());
        }
        catch (CModelException cModelException) {
            return new NullRange();
        }
    }

    public long getSnapshotTime() {
        return 0L;
    }

    public int getStyleCode() {
        switch (this.fType) {
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                return 8;
            }
            case 73: 
            case 74: 
            case 88: 
            case 89: {
                return 6;
            }
            case 72: {
                return 11;
            }
            case 76: 
            case 77: {
                return 10;
            }
            case 65: 
            case 82: 
            case 83: {
                return 1;
            }
            case 67: 
            case 84: 
            case 85: {
                return 2;
            }
            case 69: 
            case 86: 
            case 87: {
                return 3;
            }
            case 63: {
                return 16;
            }
            case 81: {
                return 12;
            }
            case 61: {
                return 0;
            }
            case 80: {
                return 17;
            }
            case 79: {
                return 13;
            }
        }
        return 0;
    }

    public ISourceTag getSourceTagAdapter() {
        return this;
    }

    public class CIdentifierRange
    implements ISourceRange {
        private org.eclipse.cdt.core.model.ISourceRange fRange;

        public CIdentifierRange(org.eclipse.cdt.core.model.ISourceRange sourceRange) {
            this.fRange = sourceRange;
        }

        public boolean contains(int offset) {
            return this.fRange.getIdStartPos() <= offset && offset - this.fRange.getIdStartPos() < this.fRange.getIdLength();
        }

        public int getBeginOffset() {
            return this.fRange.getIdStartPos();
        }

        public int getEndOffset() {
            return this.fRange.getIdStartPos() + this.fRange.getIdLength() - 1;
        }

        public int compareTo(ISourceRange other) {
            int delta = this.getBeginOffset() - other.getBeginOffset();
            if (delta == 0) {
                delta = this.getEndOffset() - other.getEndOffset();
            }
            return delta;
        }
    }

    public class CSourceRange
    implements ISourceRange {
        private org.eclipse.cdt.core.model.ISourceRange fRange;

        public CSourceRange(org.eclipse.cdt.core.model.ISourceRange sourceRange) {
            this.fRange = sourceRange;
        }

        public boolean contains(int offset) {
            return this.fRange.getStartPos() <= offset && offset - this.fRange.getStartPos() < this.fRange.getLength();
        }

        public int getBeginOffset() {
            return this.fRange.getStartPos();
        }

        public int getEndOffset() {
            return this.fRange.getStartPos() + this.fRange.getLength() - 1;
        }

        public int compareTo(ISourceRange other) {
            int delta = this.getBeginOffset() - other.getBeginOffset();
            if (delta == 0) {
                delta = this.getEndOffset() - other.getEndOffset();
            }
            return delta;
        }
    }

    public class NullRange
    implements ISourceRange {
        public boolean contains(int offset) {
            return false;
        }

        public int getBeginOffset() {
            return 0;
        }

        public int getEndOffset() {
            return -1;
        }

        public int compareTo(ISourceRange other) {
            if (this == other) {
                return 0;
            }
            return -1;
        }
    }
}

