/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.wizards;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractWizardPage
extends WizardPage {
    private ModifyListener modificationListener;
    private SelectionListener selectionListener;
    private Set<Control> monitors;

    protected AbstractWizardPage(String pageName) {
        super(pageName);
    }

    protected AbstractWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected abstract void updatePageComplete();

    protected void addMonitor(Control control) {
        if (this.monitors == null) {
            this.monitors = new HashSet<Control>();
        }
        if (control instanceof Text) {
            ((Text)control).addModifyListener(this.getModifyListener());
            this.monitors.add(control);
            return;
        }
        if (control instanceof Combo) {
            ((Combo)control).addModifyListener(this.getModifyListener());
            this.monitors.add(control);
            return;
        }
        if (control instanceof Button) {
            ((Button)control).addSelectionListener(this.getSelectionListener());
            this.monitors.add(control);
            return;
        }
    }

    private void removeMonitor(Control control) {
        if (control instanceof Text) {
            ((Text)control).removeModifyListener(this.getModifyListener());
            return;
        }
        if (control instanceof Combo) {
            ((Combo)control).removeModifyListener(this.getModifyListener());
            return;
        }
        if (control instanceof Button) {
            ((Button)control).removeSelectionListener(this.getSelectionListener());
            return;
        }
    }

    private ModifyListener getModifyListener() {
        if (this.modificationListener == null) {
            this.modificationListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AbstractWizardPage.this.updatePageComplete();
                }
            };
        }
        return this.modificationListener;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractWizardPage.this.updatePageComplete();
                }
            };
        }
        return this.selectionListener;
    }

    public void dispose() {
        if (this.monitors != null) {
            for (Control control : this.monitors) {
                this.removeMonitor(control);
            }
        }
        super.dispose();
    }
}

