/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;
import org.eclipse.dd.mi.service.command.output.MIVar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVarListChildrenInfo
extends MIInfo {
    MIVar[] children;
    int numchild;

    public MIVarListChildrenInfo(MIOutput record) {
        super(record);
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIVar> aList = new ArrayList<MIVar>();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("numchild")) {
                    if (!(value instanceof MIConst)) continue;
                    String str = ((MIConst)value).getString();
                    try {
                        this.numchild = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("children")) continue;
                this.parseChildren(value, aList);
            }
        }
        this.children = aList.toArray(new MIVar[aList.size()]);
    }

    public MIVar[] getMIVars() {
        return this.children;
    }

    private void parseChildren(MIValue val, List<MIVar> aList) {
        MIResult[] results = null;
        if (val instanceof MITuple) {
            results = ((MITuple)val).getMIResults();
        } else if (val instanceof MIList) {
            results = ((MIList)val).getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                MIValue value;
                String var = results[i].getVariable();
                if (!var.equals("child") || !((value = results[i].getMIValue()) instanceof MITuple)) continue;
                aList.add(new MIVar((MITuple)value));
            }
        }
    }
}

