/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentInstanceNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.HierarchicalConnectionNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Interconnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritDesignDocument
extends SpiritDocument {
    public static final String DOCUMENT_TYPE = "design";

    public SpiritDesignDocument(Document xmlDoc) {
        super(xmlDoc);
    }

    @Override
    public String getRootTagName() {
        return DOCUMENT_TYPE;
    }

    public static String getRootTag() {
        return DOCUMENT_TYPE;
    }

    @Override
    public String[] attributeValueSuggestions(Node node, String attribute) {
        ArrayList<String> resultsList = new ArrayList<String>();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node != null) {
            if ((node.getLocalName().equals("activeInterface") || node.getLocalName().equals("monitorInterface")) && attribute.equals("componentRef")) {
                SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)node);
                NodeList componentInstances = spiritNode.getNodeList("componentInstance");
                resultsList = spiritNode.getTextList(componentInstances, "instanceName", resultsList);
            } else if ((node.getLocalName().equals("activeInterface") || node.getLocalName().equals("monitorInterface")) && attribute.equals("busRef")) {
                String namespace = ((Element)node).getNamespaceURI();
                String cname = ((Element)node).getAttributeNS(namespace, "componentRef");
                SpiritNode spiritNode = SpiritNode.createSpiritNode((Element)node);
                NodeList componentInstances = spiritNode.getNodeList("componentInstance");
                boolean instanceset = false;
                Vlnv vlnv = null;
                block1: for (int j = 0; j < componentInstances.getLength(); ++j) {
                    Node e = componentInstances.item(j);
                    String sname = null;
                    for (Node cnode = e.getFirstChild(); cnode != null; cnode = cnode.getNextSibling()) {
                        Node tnode;
                        if (cnode.getNodeType() != 1 || !cnode.getLocalName().equals("instanceName")) continue;
                        for (tnode = cnode.getFirstChild(); tnode != null && tnode.getNodeType() != 3; tnode = tnode.getNextSibling()) {
                        }
                        if (tnode == null) continue;
                        sname = tnode.getNodeValue();
                        if (!sname.equals(cname)) continue block1;
                        instanceset = true;
                        String localname = cnode.getLocalName();
                        while (localname == null || !localname.equals("componentRef")) {
                            cnode = cnode.getNextSibling();
                            localname = cnode.getLocalName();
                        }
                        if (!cnode.getLocalName().equals("componentRef")) continue block1;
                        spiritNode = SpiritNode.createSpiritNode((Element)cnode);
                        vlnv = spiritNode.getVlnvAttribute();
                        continue block1;
                    }
                }
                if (instanceset) {
                    NodeList busInterfaces = spiritNode.getNodeList(vlnv, "busInterface");
                    resultsList = spiritNode.getTextList(busInterfaces, "name", resultsList);
                }
            }
        }
        if (resultsList.size() == 0) {
            return super.attributeValueSuggestions(node, attribute);
        }
        String[] dummy = new String[]{};
        return resultsList.toArray(dummy);
    }

    public ComponentInstanceNode getComponentInstance(String instanceName) {
        for (ComponentInstanceNode instance : this.getComponentInstances()) {
            if (!instance.getName().equals(instanceName)) continue;
            return instance;
        }
        return null;
    }

    public List<ComponentInstanceNode> getComponentInstances() {
        return this.getDescendants("componentInstance", ComponentInstanceNode.class);
    }

    public Interconnection getInterconnection(String interconnectionName) {
        return this.getNamedSubitem("interconnection", interconnectionName, Interconnection.class);
    }

    public List<HierarchicalConnectionNode> getHierarchicalConnections() {
        return this.getDescendants("hierConnection", HierarchicalConnectionNode.class);
    }
}

