/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AddressBlock;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Bank;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ConflictingWidthsException;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.MemoryMap;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckMemoryMaps {
    public static int checkMemoryMaps(DocumentChecker checker) {
        int nErrors = CheckMemoryMaps.checkMemoryMapModularity(checker);
        nErrors += CheckMemoryMaps.checkSubspaceMaps(checker);
        return nErrors += CheckMemoryMaps.checkParallelBankSubWidths(checker);
    }

    public static int checkMemoryMapModularity(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList memoryMapList = theDoc.getDescendants("memoryMap");
        for (int index = 0; index < memoryMapList.getLength(); ++index) {
            MemoryMap memoryMapNode = new MemoryMap((Element)memoryMapList.item(index));
            String name = SpiritNode.createSpiritNode((SpiritNode)memoryMapNode).getName();
            int bitsInLau = memoryMapNode.getBitsInLau();
            List addressBlocks = memoryMapNode.getAddressBlocks();
            for (AddressBlock addressBlock : addressBlocks) {
                long width = -1L;
                try {
                    width = addressBlock.getWidth();
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_54, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_5, nfe.getMessage()), (SpiritNode)addressBlock);
                    ++nErrors;
                }
                if (width < 1L) {
                    reporter.report(CheckList.CHECK_54, theDoc, Messages.CheckMemoryMaps_6, (SpiritNode)addressBlock);
                    ++nErrors;
                }
                if (width % (long)bitsInLau == 0L) continue;
                reporter.report(CheckList.CHECK_54, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_7, name, String.valueOf(width), String.valueOf(bitsInLau)), (SpiritNode)addressBlock);
                ++nErrors;
            }
        }
        return nErrors;
    }

    public static int checkSubspaceMaps(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList bankList = theDoc.getDescendants("bank");
        for (int bIndex = 0; bIndex < bankList.getLength(); ++bIndex) {
            NodeList subspaceMapList;
            Element bank = (Element)bankList.item(bIndex);
            SpiritNode bankNode = SpiritNode.createSpiritNode((Element)bank);
            if (!bankNode.getSpiritAttribute("bankAlignment").equals("parallel") || (subspaceMapList = bankNode.getDescendants("subspaceMap")).getLength() <= 0) continue;
            reporter.report(CheckList.CHECK_55, theDoc, Messages.CheckMemoryMaps_9, subspaceMapList.item(0));
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkParallelBankSubWidths(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList bankList = theDoc.getDescendants("bank");
        for (int bIndex = 0; bIndex < bankList.getLength(); ++bIndex) {
            Element bank = (Element)bankList.item(bIndex);
            Bank bankNode = new Bank(bank);
            if (!bankNode.getSpiritAttribute("bankAlignment").equals("parallel")) continue;
            try {
                bankNode.getWidth();
                continue;
            }
            catch (NumberFormatException nfe) {
                reporter.report(CheckList.CHECK_56, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_13, nfe.getMessage()), bank);
                ++nErrors;
                continue;
            }
            catch (ConflictingWidthsException cwe) {
                reporter.report(CheckList.CHECK_56, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_14, String.valueOf(cwe.newWidth), String.valueOf(cwe.newWidth)), cwe.node);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

