/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Field;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Register;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.utils.Decode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckRegisters {
    public static int checkRanges(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList registerNodes = theDoc.getDescendants("register");
        int registerCount = registerNodes.getLength();
        if (registerCount < 1) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckRegisters_1);
            ++nErrors;
        }
        NodeList addressBlockNodes = theDoc.getDescendants("addressBlock");
        for (int ab = 0; ab < addressBlockNodes.getLength(); ++ab) {
            Element addressBlockNode = (Element)addressBlockNodes.item(ab);
            String addressBlockAccess = SpiritNode.createSpiritNode((Element)addressBlockNode).getUniqueChildText("access");
            ArrayList<Register> registers = new ArrayList<Register>();
            registerNodes = SpiritNode.createSpiritNode((Element)addressBlockNode).getDescendants("register");
            registerCount = registerNodes.getLength();
            for (int index = 0; index < registerCount; ++index) {
                Element registerNode = (Element)registerNodes.item(index);
                try {
                    Register register = new Register(registerNode);
                    registers.add(register);
                    nErrors += CheckRegisters.checkRegister(checker, addressBlockAccess, register);
                    continue;
                }
                catch (Exception e) {
                    reporter.report(CheckList.CHECK_50, theDoc, MessageFormat.format(Messages.CheckRegisters_5, e), registerNode);
                    ++nErrors;
                }
            }
            if (registers.isEmpty()) continue;
            Element memoryMapNode = (Element)addressBlockNode.getParentNode();
            int bitsInLau = 0;
            String bitsInLauString = SpiritNode.createSpiritNode((Element)memoryMapNode).getUniqueDescendantText("bitsInLau");
            if (bitsInLauString.length() > 0) {
                bitsInLau = Integer.parseInt(bitsInLauString);
            }
            if (bitsInLau < 1) {
                bitsInLau = 8;
            }
            nErrors += CheckRegisters.checkRegisterOverlapsAndRange(checker, addressBlockNode, registers, bitsInLau);
            nErrors += CheckRegisters.checkFieldOverlapsAndRange(checker, registers, bitsInLau);
        }
        return nErrors;
    }

    private static int checkRegister(DocumentChecker checker, String addressBlockAccess, Register register) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        if (addressBlockAccess.length() > 0 && !register.getAccess().equals(addressBlockAccess)) {
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_7, addressBlockAccess, register.getAccess(), register), (SpiritNode)register);
            ++nErrors;
        }
        if (register.getDescription().length() < 1) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckRegisters_8, register), (SpiritNode)register);
            ++nErrors;
        }
        if (register.getResetValue().length() < 1 && !"write-only".equals(register.getAccess())) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckRegisters_10, register), (SpiritNode)register);
            ++nErrors;
        }
        if (register.getSize() == 0) {
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_11, register), (SpiritNode)register);
            ++nErrors;
        }
        return nErrors;
    }

    private static int checkRegisterOverlapsAndRange(DocumentChecker checker, Element addressBlockNode, List<Register> registers, int bitsInLau) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        class LowHigh {
            final Register register;
            final long low;
            final long high;

            LowHigh(Register register, long low, long high) {
                this.register = register;
                this.low = low;
                this.high = high;
            }
        }
        ArrayList<LowHigh> items = new ArrayList<LowHigh>();
        long maxAddressOffset = 0L;
        for (Register register : registers) {
            int instances = 1;
            for (Integer dim : register.getDims()) {
                instances *= dim.intValue();
            }
            int addressUnits = (instances * register.getSize() + bitsInLau - 1) / bitsInLau;
            long low = register.getAddressOffset();
            long high = low + (long)addressUnits - 1L;
            LowHigh lowHigh = new LowHigh(register, low, high);
            for (LowHigh item : items) {
                if ((low < item.low || low > item.high) && (high < item.low || high > item.high)) continue;
                reporter.report(CheckList.CHECK_50, theDoc, MessageFormat.format(Messages.CheckRegisters_12, register, item.register), (SpiritNode)register);
                ++nErrors;
            }
            items.add(lowHigh);
            maxAddressOffset = Math.max(maxAddressOffset, high);
        }
        long range = 0L;
        try {
            String value = SpiritNode.createSpiritNode((Element)addressBlockNode).getUniqueChildText("range");
            range = Decode.decode((String)value);
        }
        catch (NumberFormatException e) {
            reporter.report(CheckList.CHECK_52, theDoc, MessageFormat.format(Messages.CheckRegisters_14, e), addressBlockNode);
            ++nErrors;
        }
        if (range < maxAddressOffset) {
            reporter.report(CheckList.CHECK_52, theDoc, MessageFormat.format(Messages.CheckRegisters_15, Long.toHexString(range), Long.toHexString(maxAddressOffset)), addressBlockNode);
            ++nErrors;
        }
        return nErrors;
    }

    private static int checkFieldOverlapsAndRange(DocumentChecker checker, List<Register> registers, int bitsInLau) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        class LowHigh {
            final Field field;
            final long low;
            final long high;

            LowHigh(Field field, long low, long high) {
                this.field = field;
                this.low = low;
                this.high = high;
            }
        }
        ArrayList<LowHigh> items = new ArrayList<LowHigh>();
        for (Register register : registers) {
            int registerSize = register.getSize();
            NodeList fieldNodes = register.getDescendants("field");
            int fieldCount = fieldNodes.getLength();
            if (fieldCount == 0) {
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckRegisters_17, register), (SpiritNode)register);
                ++nErrors;
            }
            items.clear();
            for (int index = 0; index < fieldCount; ++index) {
                Element fieldNode = (Element)fieldNodes.item(index);
                try {
                    Field field = new Field(fieldNode);
                    nErrors += CheckRegisters.checkField(checker, register.getAccess(), field);
                    long low = field.getBitOffset();
                    long high = low + (long)field.getBitWidth() - 1L;
                    LowHigh lowHigh = new LowHigh(field, low, high);
                    for (LowHigh item : items) {
                        if ((low < item.low || low > item.high) && (high < item.low || high > item.high)) continue;
                        Field otherField = item.field;
                        if (low == otherField.getBitOffset() && field.getBitWidth() == otherField.getBitWidth() && ("read-only".equals(field.getAccess()) && "write-only".equals(otherField.getAccess()) || "read-only".equals(otherField.getAccess()) && "write-only".equals(field.getAccess()))) {
                            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_22, field, otherField), fieldNode);
                            ++nErrors;
                            continue;
                        }
                        reporter.report(CheckList.CHECK_51, theDoc, MessageFormat.format(Messages.CheckRegisters_23, field, otherField), fieldNode);
                        ++nErrors;
                    }
                    items.add(lowHigh);
                    if (low < (long)registerSize && high < (long)registerSize) continue;
                    reporter.report(CheckList.CHECK_53, theDoc, MessageFormat.format(Messages.CheckRegisters_24, field), fieldNode);
                    ++nErrors;
                    continue;
                }
                catch (Exception e) {
                    reporter.report(CheckList.CHECK_51, theDoc, MessageFormat.format(Messages.CheckRegisters_25, e), fieldNode);
                    ++nErrors;
                }
            }
        }
        return nErrors;
    }

    private static int checkField(DocumentChecker checker, String registerAccess, Field field) {
        int bitWidth;
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        String fieldAccess = field.getAccess();
        if (registerAccess.length() > 0 && fieldAccess.length() > 0 && !fieldAccess.equals(registerAccess)) {
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_26, registerAccess, fieldAccess, field), (SpiritNode)field);
            ++nErrors;
        }
        if ((bitWidth = field.getBitWidth()) == 0) {
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_27, field), (SpiritNode)field);
            ++nErrors;
        } else {
            long maxValue = (1L << bitWidth) - 1L;
            for (Long value : field.getValues()) {
                if (value <= maxValue) continue;
                reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckRegisters_28, value, new Integer(bitWidth)), (SpiritNode)field);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

