/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.object;

import javax.xml.xpath.XPathExpression;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.object.SpiritCreatableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ComponentInstance
extends SpiritCreatableObject {
    private Vlnv componentId;
    private String instanceName;
    private boolean isSelected = false;
    private static int newInstanceIdCount = 1;
    private String generatedInstanceName = null;
    private Element xmlRootNode = null;
    private boolean isNewNode = true;

    public ComponentInstance(Vlnv componentId) {
        this.componentId = componentId;
        this.isNewNode = true;
    }

    public ComponentInstance(SpiritDocument sDoc, Element instanceElement) {
        this.xmlRootNode = instanceElement;
        this.isNewNode = false;
        try {
            sDoc.createXPath().compile("./spirit:componentRef");
            this.componentId = sDoc.getVlnv();
            XPathExpression inameEvaluator = sDoc.createXPath().compile("./spirit:instanceName/text()");
            this.setInstanceName(inameEvaluator.evaluate(instanceElement));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public Vlnv getComponentId() {
        return this.componentId;
    }

    public void setInstanceName(String newName) {
        this.instanceName = newName != null && newName.trim().length() > 0 ? newName : null;
    }

    public Element getXMLRootNode(Document document) {
        if (this.xmlRootNode == null) {
            this.xmlRootNode = this.createNewNode(document);
        }
        return this.xmlRootNode;
    }

    public Element createNewNode(Document document) {
        Element newRootNode = null;
        newRootNode = document.createElement("spirit:componentInstance");
        Element e = document.createElement("spirit:instanceName");
        Text text = document.createTextNode(this.getInstanceName(true));
        e.appendChild(text);
        newRootNode.appendChild(e);
        e = document.createElement("spirit:componentRef");
        this.componentId.addAttributesToXmlElement(e);
        newRootNode.appendChild(e);
        return newRootNode;
    }

    public String getInstanceName(boolean useDefault) {
        if (this.instanceName == null && useDefault) {
            return this.getDefaultName();
        }
        return this.instanceName;
    }

    private String getDefaultName() {
        if (this.generatedInstanceName == null) {
            this.generatedInstanceName = this.componentId.toString() + "_" + newInstanceIdCount++;
        }
        return this.generatedInstanceName;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelectedState(boolean checkState) {
        this.isSelected = checkState;
    }

    public boolean isNewNode() {
        return this.isNewNode;
    }
}

