/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.common;

import java.math.BigInteger;

public final class DsfMIFormat {
    public static final int HEXADECIMAL = 0;
    public static final int OCTAL = 1;
    public static final int BINARY = 2;
    public static final int DECIMAL = 3;
    public static final int RAW = 4;
    public static final int NATURAL = 5;
    public static final int FLOAT = 10;
    public static final int ADDRESS = 11;
    public static final int INSTRUCTION = 12;
    public static final int CHAR = 13;
    public static final int STRING = 14;
    public static final int UNSIGNED = 15;

    private DsfMIFormat() {
    }

    public static BigInteger decodeAdress(String buffer) {
        int radix = 10;
        int cursor = 0;
        int offset = 0;
        int len = buffer.length();
        offset = buffer.indexOf("0x");
        if (offset != -1 || (offset = buffer.indexOf("0X")) != -1) {
            radix = 16;
            cursor = offset + 2;
        }
        while (cursor < len && Character.digit(buffer.charAt(cursor), radix) != -1) {
            ++cursor;
        }
        String s = buffer.substring(offset, cursor);
        return DsfMIFormat.getBigInteger(s);
    }

    public static BigInteger getBigInteger(String address) {
        int index = 0;
        int radix = 10;
        boolean negative = false;
        if ((address = address.trim()).length() == 0) {
            return BigInteger.ZERO;
        }
        if (address.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (address.startsWith("0x", index) || address.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (address.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (address.startsWith("0", index) && address.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (index > 0) {
            address = address.substring(index);
        }
        if (negative) {
            address = "-" + address;
        }
        try {
            return new BigInteger(address, radix);
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }
}

