/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIArg {
    String name;
    String value;

    public DsfMIArg(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static DsfMIArg[] getMIArgs(DsfMIList miList) {
        ArrayList<DsfMIArg> aList = new ArrayList<DsfMIArg>();
        DsfMIValue[] values = miList.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            DsfMIArg arg;
            if (!(values[i] instanceof DsfMITuple) || (arg = DsfMIArg.getMIArg((DsfMITuple)values[i])) == null) continue;
            aList.add(arg);
        }
        DsfMIResult[] results = miList.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            DsfMIValue value = results[i].getMIValue();
            if (!(value instanceof DsfMIConst)) continue;
            String str = ((DsfMIConst)value).getCString();
            aList.add(new DsfMIArg(str, ""));
        }
        return aList.toArray(new DsfMIArg[aList.size()]);
    }

    public static DsfMIArg[] getMIArgs(DsfMITuple miTuple) {
        ArrayList<DsfMIArg> aList = new ArrayList<DsfMIArg>();
        DsfMIValue[] values = miTuple.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            DsfMIArg arg;
            if (!(values[i] instanceof DsfMITuple) || (arg = DsfMIArg.getMIArg((DsfMITuple)values[i])) == null) continue;
            aList.add(arg);
        }
        DsfMIResult[] results = miTuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            DsfMIValue value = results[i].getMIValue();
            if (!(value instanceof DsfMIConst)) continue;
            String str = ((DsfMIConst)value).getCString();
            aList.add(new DsfMIArg(str, ""));
        }
        return aList.toArray(new DsfMIArg[aList.size()]);
    }

    public static DsfMIArg getMIArg(DsfMITuple tuple) {
        DsfMIResult[] args = tuple.getMIResults();
        DsfMIArg arg = null;
        if (args.length > 0) {
            String aName = "";
            DsfMIValue value = args[0].getMIValue();
            aName = value != null && value instanceof DsfMIConst ? ((DsfMIConst)value).getCString() : "";
            String aValue = "";
            if (args.length == 2) {
                value = args[1].getMIValue();
                aValue = value != null && value instanceof DsfMIConst ? ((DsfMIConst)value).getCString() : "";
            }
            arg = new DsfMIArg(aName, aValue);
        }
        return arg;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

