/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataListRegisterValues;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIRegisterValue;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIDataListRegisterValuesInfo
extends DsfMIInfo {
    DsfMIRegisterValue[] registers = null;

    public DsfMIDataListRegisterValuesInfo(DsfMIOutput rr) {
        super(rr);
        DsfMIOutput out;
        DsfMIResultRecord outr;
        if (this.isDone() && (outr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            DsfMIResult[] results = outr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                DsfMIValue value;
                String var = results[i].getVariable();
                if (!var.equals("register-values") || !((value = results[i].getMIValue()) instanceof DsfMIList)) continue;
                this.registers = DsfMIRegisterValue.getMIRegisterValues((DsfMIList)value);
            }
        }
        if (this.registers == null) {
            this.registers = new DsfMIRegisterValue[0];
        }
    }

    public DsfMIRegisterValue[] getMIRegisterValues() {
        return this.registers;
    }

    @Override
    public <V extends ICommandResult> V getSubsetResult(ICommand<V> cmd) {
        if (cmd instanceof DsfMIDataListRegisterValues) {
            DsfMIDataListRegisterValues command = (DsfMIDataListRegisterValues)cmd;
            ArrayList<DsfMIRegisterValue> aList = new ArrayList<DsfMIRegisterValue>();
            int[] wantedRegNos = command.getRegList();
            for (DsfMIRegisterValue regVal : this.registers) {
                for (int curRegNo : wantedRegNos) {
                    if (regVal.getNumber() != curRegNo) continue;
                    aList.add(regVal);
                }
            }
            DsfMIRegisterValue[] finalRegSet = aList.toArray(new DsfMIRegisterValue[aList.size()]);
            DsfMIDataListRegisterValuesInfo finalSubset = new DsfMIDataListRegisterValuesInfo(this.getMIOutput());
            finalSubset.registers = finalRegSet;
            DsfMIDataListRegisterValuesInfo vFinalSubset = finalSubset;
            return (V)vFinalSubset;
        }
        return super.getSubsetResult(cmd);
    }
}

