/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIInfo
implements ICommandResult {
    private final DsfMIOutput miOutput;

    public DsfMIInfo(DsfMIOutput record) {
        this.miOutput = record;
    }

    public DsfMIOutput getMIOutput() {
        return this.miOutput;
    }

    public boolean isDone() {
        return this.isResultClass("done");
    }

    public boolean isRunning() {
        return this.isResultClass("running");
    }

    public boolean isConnected() {
        return this.isResultClass("connected");
    }

    public boolean isError() {
        return this.isResultClass("error");
    }

    public boolean isExit() {
        return this.isResultClass("exit");
    }

    public String toString() {
        if (this.miOutput != null) {
            return this.miOutput.toString();
        }
        return "";
    }

    boolean isResultClass(String rc) {
        DsfMIResultRecord rr;
        if (this.miOutput != null && (rr = this.miOutput.getMIResultRecord()) != null) {
            String clazz = rr.getResultClass();
            return clazz.equals(rc);
        }
        return false;
    }

    public String getErrorMsg() {
        DsfMIResultRecord rr;
        if (this.miOutput != null && (rr = this.miOutput.getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                DsfMIValue value;
                String var = results[i].getVariable();
                if (!var.equals("msg") || !((value = results[i].getMIValue()) instanceof DsfMIConst)) continue;
                String s = ((DsfMIConst)value).getCString();
                return s;
            }
        }
        return "";
    }

    public <V extends ICommandResult> V getSubsetResult(ICommand<V> command) {
        return null;
    }
}

