/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIRegisterValue {
    int number;
    String value;

    public DsfMIRegisterValue(int n, String v) {
        this.number = n;
        this.value = v;
    }

    public int getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=\"").append(this.number).append('\"');
        buffer.append(',').append("value=\"" + this.value + "\"");
        return buffer.toString();
    }

    public static DsfMIRegisterValue[] getMIRegisterValues(DsfMIList miList) {
        ArrayList<DsfMIRegisterValue> aList = new ArrayList<DsfMIRegisterValue>();
        DsfMIValue[] values = miList.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            DsfMIRegisterValue reg;
            if (!(values[i] instanceof DsfMITuple) || (reg = DsfMIRegisterValue.getMIRegisterValue((DsfMITuple)values[i])) == null) continue;
            aList.add(reg);
        }
        return aList.toArray(new DsfMIRegisterValue[aList.size()]);
    }

    public static DsfMIRegisterValue getMIRegisterValue(DsfMITuple tuple) {
        DsfMIResult[] args = tuple.getMIResults();
        DsfMIRegisterValue arg = null;
        if (args.length == 2) {
            String aName = "";
            DsfMIValue value = args[0].getMIValue();
            aName = value != null && value instanceof DsfMIConst ? ((DsfMIConst)value).getCString() : "";
            String aValue = "";
            value = args[1].getMIValue();
            aValue = value != null && value instanceof DsfMIConst ? ((DsfMIConst)value).getCString() : "";
            try {
                int reg = Integer.parseInt(aName.trim());
                arg = new DsfMIRegisterValue(reg, aValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return arg;
    }
}

