/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIStackListFramesInfo
extends DsfMIInfo {
    DsfMIFrame[] frames = null;

    public DsfMIStackListFramesInfo(DsfMIOutput out) {
        super(out);
        DsfMIResultRecord rr;
        ArrayList<DsfMIFrame> aList = new ArrayList<DsfMIFrame>(1);
        if (this.isDone() && (rr = out.getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("stack")) continue;
                DsfMIValue val = results[i].getMIValue();
                if (val instanceof DsfMIList) {
                    this.parseStack((DsfMIList)val, aList);
                    continue;
                }
                if (!(val instanceof DsfMITuple)) continue;
                this.parseStack((DsfMITuple)val, aList);
            }
        }
        this.frames = aList.toArray(new DsfMIFrame[aList.size()]);
    }

    public DsfMIFrame[] getMIFrames() {
        return this.frames;
    }

    void parseStack(DsfMIList miList, List<DsfMIFrame> aList) {
        DsfMIResult[] results = miList.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            DsfMIValue value;
            String var = results[i].getVariable();
            if (!var.equals("frame") || !((value = results[i].getMIValue()) instanceof DsfMITuple)) continue;
            aList.add(new DsfMIFrame((DsfMITuple)value));
        }
    }

    void parseStack(DsfMITuple tuple, List<DsfMIFrame> aList) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            DsfMIValue value;
            String var = results[i].getVariable();
            if (!var.equals("frame") || !((value = results[i].getMIValue()) instanceof DsfMITuple)) continue;
            aList.add(new DsfMIFrame((DsfMITuple)value));
        }
    }
}

