/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIVarUpdateInfo
extends DsfMIInfo {
    DsfMIVarChange[] changeList;

    public DsfMIVarUpdateInfo(DsfMIOutput record) {
        super(record);
        DsfMIOutput out;
        DsfMIResultRecord rr;
        ArrayList<DsfMIVarChange> aList = new ArrayList<DsfMIVarChange>();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("changelist")) continue;
                DsfMIValue value = results[i].getMIValue();
                if (value instanceof DsfMITuple) {
                    this.parseChangeList((DsfMITuple)value, aList);
                    continue;
                }
                if (!(value instanceof DsfMIList)) continue;
                this.parseChangeList((DsfMIList)value, aList);
            }
        }
        this.changeList = aList.toArray(new DsfMIVarChange[aList.size()]);
    }

    public DsfMIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    void parseChangeList(DsfMIList miList, List<DsfMIVarChange> aList) {
        DsfMIValue[] values = miList.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof DsfMITuple) {
                this.parseChangeList((DsfMITuple)values[i], aList);
                continue;
            }
            if (!(values[i] instanceof DsfMIList)) continue;
            this.parseChangeList((DsfMIList)values[i], aList);
        }
    }

    void parseChangeList(DsfMITuple tuple, List<DsfMIVarChange> aList) {
        DsfMIResult[] results = tuple.getMIResults();
        DsfMIVarChange change = null;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            if (value instanceof DsfMITuple) {
                this.parseChangeList((DsfMITuple)value, aList);
                continue;
            }
            String str = "";
            if (value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getString();
            }
            if (var.equals("name")) {
                change = new DsfMIVarChange(str);
                aList.add(change);
                continue;
            }
            if (var.equals("in_scope")) {
                if (change == null) continue;
                change.setInScope("true".equals(str));
                continue;
            }
            if (!var.equals("type_changed") || change == null) continue;
            change.setChanged("true".equals(str));
        }
    }
}

