/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMIBreakpointHitEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = 4941768484124800880L;
    int bkptno;

    public DsfMIBreakpointHitEvent(DsfMIExecAsyncOutput record) {
        super(record);
        this.parse();
    }

    public DsfMIBreakpointHitEvent(DsfMIResultRecord record) {
        super(record);
        this.parse();
    }

    public int getNumber() {
        return this.bkptno;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.bkptno).append('\n');
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        buffer.append(this.getFrame().toString());
        return buffer.toString();
    }

    void parse() {
        DsfMIResult[] results = null;
        DsfMIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        DsfMIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (var.equals("bkptno")) {
                    try {
                        this.bkptno = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                this.setFrame(new DsfMIFrame((DsfMITuple)value));
            }
        }
    }
}

