/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMIFunctionFinishedEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = -7372630068632785573L;
    String gdbResult = "";
    String returnValue = "";
    String returnType = "";

    public DsfMIFunctionFinishedEvent(DsfMIExecAsyncOutput async) {
        super(async);
        this.parse();
    }

    public DsfMIFunctionFinishedEvent(DsfMIResultRecord record) {
        super(record);
        this.parse();
    }

    public String getGDBResultVar() {
        return this.gdbResult;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("gdb-result-var=" + this.gdbResult + "\n");
        buffer.append("return-value=" + this.returnValue + "\n");
        buffer.append("return-type=" + this.returnType + "\n");
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        DsfMIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    void parse() {
        DsfMIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        DsfMIResultRecord rr = this.getMIResultRecord();
        DsfMIResult[] results = null;
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (var.equals("gdb-result-var")) {
                    this.gdbResult = str;
                    continue;
                }
                if (var.equals("return-value")) {
                    this.returnValue = str;
                    continue;
                }
                if (var.equals("return-type")) {
                    this.returnType = str;
                    continue;
                }
                if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                DsfMIFrame f = new DsfMIFrame((DsfMITuple)value);
                this.setFrame(f);
            }
        }
    }
}

