/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIDestroyedEvent;

public class DsfMIInferiorExitEvent
extends DsfMIDestroyedEvent {
    private static final long serialVersionUID = -3868927922220038243L;
    int code = 0;
    DsfMIExecAsyncOutput exec = null;
    DsfMIResultRecord rr = null;

    public DsfMIInferiorExitEvent(int token) {
        super(token);
    }

    public DsfMIInferiorExitEvent(DsfMIExecAsyncOutput async) {
        super(async.getToken());
        this.exec = async;
        this.parse();
    }

    public DsfMIInferiorExitEvent(DsfMIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public int getExitCode() {
        return this.code;
    }

    void parse() {
        DsfMIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (!var.equals("exit-code")) continue;
                try {
                    this.code = Integer.decode(str.trim());
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

