/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMILocationReachedEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = 1735805136361543704L;

    public DsfMILocationReachedEvent(DsfMIExecAsyncOutput async) {
        super(async);
        this.parse();
    }

    public DsfMILocationReachedEvent(DsfMIResultRecord record) {
        super(record);
        this.parse();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        DsfMIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    void parse() {
        DsfMIResult[] results = null;
        DsfMIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        DsfMIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                DsfMIFrame f = new DsfMIFrame((DsfMITuple)value);
                this.setFrame(f);
            }
        }
    }
}

