/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.datamodel.ServiceDMContext;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataListRegisterNames;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataListRegisterValues;
import org.eclipse.dd.dsf.mi.core.output.DsfMIDataListRegisterNamesInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIDataListRegisterValuesInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIRegisterValue;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRegisters
extends AbstractDsfService
implements IDMService,
IRegisters {
    private MIRunControl fRunControl;
    private IDMContext<MIRegisters> fServiceDMC;
    private MIRegisterGroupDMC fGeneralRegistersGroupDMC;
    private MICommandCache fRegisterNameCache;
    private MICommandCache fRegisterValueCache;

    public MIRegisters(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(this.getExecutor(), requestMonitor){

            protected void handleOK() {
                MIRegisters.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fRegisterValueCache = new MICommandCache((ICommandControl)this.getServicesTracker().getService(ICommandControl.class));
        this.fRegisterNameCache = new MICommandCache((ICommandControl)this.getServicesTracker().getService(ICommandControl.class));
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IRegisters.class.getName(), MIRegisters.class.getName()}, new Hashtable());
        this.fServiceDMC = new ServiceDMContext((IDMService)this, "#registers");
        this.fRunControl = (MIRunControl)this.getServicesTracker().getService(MIRunControl.class);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    public IDMContext<MIRegisters> getServiceContext() {
        return this.fServiceDMC;
    }

    public boolean isValid() {
        return true;
    }

    public <V extends IDMData> void getModelData(IDMContext<V> dmc, DataRequestMonitor<V> rm) {
        if (dmc instanceof MIRegisterGroupDMC) {
            this.getRegisterGroupData((MIRegisterGroupDMC)dmc, rm);
        } else if (dmc instanceof MIRegisterDMC) {
            this.getRegisterData((MIRegisterDMC)dmc, rm);
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext && dmc.getParents().length == 1) {
            if (dmc.getParents()[0] instanceof MIRegisterDMC) {
                this.getRegisterDataValue((MIRegisterDMC)dmc.getParents()[0], ((IFormattedValues.FormattedValueDMContext)dmc).getFormatID(), rm);
            }
        } else if (dmc == this.fServiceDMC) {
            rm.setData((Object)this);
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", -1, "Unknown DMC type", null));
            rm.done();
        }
    }

    private void getRegisterGroupData(MIRegisterGroupDMC regGroupDmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        class RegisterGroupData
        implements IRegisters.IRegisterGroupDMData {
            RegisterGroupData() {
            }

            public String getName() {
                return "General Registers";
            }

            public String getDescription() {
                return "General Purpose and FPU Register Group";
            }

            public boolean isValid() {
                return true;
            }
        }
        rm.setData((Object)new RegisterGroupData());
        rm.done();
    }

    private void getRegisterData(final MIRegisterDMC regDmc, final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
        int[] regnos = new int[]{regDmc.getRegNo()};
        this.fRegisterValueCache.execute(new DsfMIDataListRegisterValues(0, regnos), new DataRequestMonitor<DsfMIDataListRegisterValuesInfo>(this.getExecutor(), rm){

            protected void handleOK() {
                DsfMIRegisterValue[] regValue = ((DsfMIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                if (regValue.length == 0) {
                    assert (false) : "Backend protocol error";
                    rm.done();
                    return;
                }
                DsfMIRegisterValue reg = regValue[0];
                boolean isFloat = false;
                if (reg.getValue().contains("float")) {
                    isFloat = true;
                }
                rm.setData((Object)new RegisterData(regDmc.getName(), "", isFloat));
                rm.done();
            }
        });
    }

    private void getRegisterDataValue(MIRegisterDMC regDmc, String formatId, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        int[] regnos = new int[]{regDmc.getRegNo()};
        this.fRegisterValueCache.execute(new DsfMIDataListRegisterValues(0, regnos), new DataRequestMonitor<DsfMIDataListRegisterValuesInfo>(this.getExecutor(), rm){

            protected void handleOK() {
                DsfMIRegisterValue[] regValue = ((DsfMIDataListRegisterValuesInfo)this.getData()).getMIRegisterValues();
                if (regValue.length == 0) {
                    assert (false) : "Backend protocol error";
                    rm.done();
                    return;
                }
                DsfMIRegisterValue reg = regValue[0];
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(reg.getValue()));
                rm.done();
            }
        });
    }

    private MIRegisterDMC[] makeRegisterDMCs(MIRegisterGroupDMC groupDmc, String[] regNames) {
        MIRegisterDMC[] regDmcList = new MIRegisterDMC[regNames.length];
        int regNo = 0;
        for (String regName : regNames) {
            regDmcList[regNo] = new MIRegisterDMC(this, groupDmc, regNo, regName);
            ++regNo;
        }
        return regDmcList;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fRegisterValueCache.setTargetAvailable(false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fRegisterValueCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fRegisterValueCache.setTargetAvailable(true);
        this.fRegisterValueCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunControl.SuspendedEvent e) {
        this.fRegisterValueCache.setTargetAvailable(true);
        this.fRegisterValueCache.reset();
    }

    public void getRegisterGroups(IDMContext<?> ctx, DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IExecutionDMContext.class);
        if (execCtx == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No execution context in: " + ctx, null));
            rm.done();
            return;
        }
        if (this.fGeneralRegistersGroupDMC == null) {
            this.fGeneralRegistersGroupDMC = new MIRegisterGroupDMC(this, execCtx, 0, "General Registers");
        }
        MIRegisterGroupDMC[] groupDMCs = new MIRegisterGroupDMC[]{this.fGeneralRegistersGroupDMC};
        rm.setData((Object)groupDMCs);
        rm.done();
    }

    public void getRegisterSubGroups(IDMContext<?> groupDmc, DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", -1, "Register subgroups not supported", null));
        rm.done();
    }

    public void getRegisters(IDMContext<?> dmc, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        final MIRegisterGroupDMC groupDmc = (MIRegisterGroupDMC)DMContexts.getAncestorOfType(dmc, MIRegisterGroupDMC.class);
        if (groupDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No group context in: " + dmc, null));
            rm.done();
            return;
        }
        if (groupDmc.getGroupNo() == 0) {
            this.fRegisterNameCache.execute(new DsfMIDataListRegisterNames(null), new DataRequestMonitor<DsfMIDataListRegisterNamesInfo>(this.getExecutor(), rm){

                protected void handleOK() {
                    String[] regNames = ((DsfMIDataListRegisterNamesInfo)this.getData()).getRegisterNames();
                    if (regNames.length == 0) {
                        rm.done();
                        return;
                    }
                    rm.setData((Object)MIRegisters.this.makeRegisterDMCs(groupDmc, regNames));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid group = " + (Object)((Object)groupDmc), null));
            rm.done();
        }
    }

    public void getBitFields(IDMContext<?> regDmc, DataRequestMonitor<IRegisters.IBitFieldDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "BitField not supported", null));
        rm.done();
    }

    public void writeRegister(IDMContext<?> regCtx, String regValue, String cormatId, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Writing register not supported", null));
        rm.done();
    }

    public void writeBitField(IDMContext<?> bitFieldCtx, String bitFieldValue, String formatId, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void writeBitField(IDMContext<?> bitFieldCtx, IRegisters.IMnemonic mnemonic, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Writing bit field not supported", null));
        rm.done();
    }

    public void getAvailableFormattedValues(IFormattedValues.IFormattedDataDMContext<?> dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"HEX.Format"});
        rm.done();
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValue(IFormattedValues.IFormattedDataDMContext<?> dmc, String formatId) {
        if (dmc instanceof MIRegisterDMC) {
            MIRegisterDMC regDmc = (MIRegisterDMC)dmc;
            return new IFormattedValues.FormattedValueDMContext((IDMService)this, (IDMContext)regDmc, formatId);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIRegisterDMC
    extends AbstractDMContext<IRegisters.IRegisterDMData>
    implements IRegisters.IRegisterDMContext {
        private int fRegNo;
        private String fRegName;

        public MIRegisterDMC(MIRegisters service, MIRegisterGroupDMC group, int regNo, String regName) {
            super(service.getSession().getId(), service.getServiceFilter(), new IDMContext[]{service.fRunControl.getExecutionDMC(), service.getServiceContext(), group});
            this.fRegNo = regNo;
            this.fRegName = regName;
        }

        public int getRegNo() {
            return this.fRegNo;
        }

        public String getName() {
            return this.fRegName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterDMC)((Object)other)).fRegNo == this.fRegNo && ((MIRegisterDMC)((Object)other)).fRegName.equals(this.fRegName);
        }

        public int hashCode() {
            return super.baseHashCode();
        }

        public String toString() {
            return this.baseToString() + ".register[" + this.fRegNo + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIRegisterGroupDMC
    extends AbstractDMContext<IRegisters.IRegisterGroupDMData>
    implements IRegisters.IRegisterGroupDMContext {
        private int fGroupNo;
        private String fGroupName;

        public MIRegisterGroupDMC(MIRegisters service, IRunControl.IExecutionDMContext execDmc, int groupNo, String groupName) {
            super(service.getSession().getId(), service.getServiceFilter(), new IDMContext[]{execDmc, service.getServiceContext()});
            this.fGroupNo = groupNo;
            this.fGroupName = groupName;
        }

        public int getGroupNo() {
            return this.fGroupNo;
        }

        public String getName() {
            return this.fGroupName;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIRegisterGroupDMC)((Object)other)).fGroupNo == this.fGroupNo && ((MIRegisterGroupDMC)((Object)other)).fGroupName.equals(this.fGroupName);
        }

        public int hashCode() {
            return super.baseHashCode();
        }

        public String toString() {
            return this.baseToString() + ".group[" + this.fGroupNo + "]";
        }
    }

    class RegisterData
    implements IRegisters.IRegisterDMData {
        private String fRegName;
        private String fRegDesc;
        private boolean fIsFloat;

        public RegisterData(String regName, String regDesc, boolean isFloat) {
            this.fRegName = regName;
            this.fRegDesc = regDesc;
            this.fIsFloat = isFloat;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isReadOnce() {
            return false;
        }

        public boolean isWriteable() {
            return true;
        }

        public boolean isWriteOnce() {
            return false;
        }

        public boolean hasSideEffects() {
            return false;
        }

        public boolean isVolatile() {
            return true;
        }

        public boolean isFloat() {
            return this.fIsFloat;
        }

        public String getName() {
            return this.fRegName;
        }

        public String getDescription() {
            return this.fRegDesc;
        }

        public boolean isValid() {
            return true;
        }
    }
}

