/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecFinish;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecInterrupt;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNext;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecRun;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStep;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIGDBExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIRunningEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISteppingRangeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIThreadExitEvent;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControl
extends AbstractDsfService
implements IDMService,
IRunControl {
    private IRunControl.IContainerDMContext fServiceDmc;
    private IRunControl.IExecutionDMContext fExecutionDmc;
    private ICommandControl fConnection;
    private MICommandCache fMICommandCache;
    private boolean fSuspended = true;
    private boolean fResumePending = false;
    private boolean fStepping = false;
    private boolean fTerminated = false;

    public MIRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(this.getExecutor(), rm){

            protected void handleOK() {
                MIRunControl.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fServiceDmc = new ServiceDMC(this);
        this.fExecutionDmc = new ExecutionDMC(this);
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fMICommandCache = new MICommandCache(this.fConnection);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public IDMContext<?> getServiceContext() {
        return this.fServiceDmc;
    }

    public boolean isValid() {
        return true;
    }

    public IRunControl.IContainerDMContext getContainerDMC() {
        return this.fServiceDmc;
    }

    public IRunControl.IExecutionDMContext getExecutionDMC() {
        return this.fExecutionDmc;
    }

    public IRunControl.IExecutionDMData getExecutionData() {
        return new ExecutionData();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Operation not implemented", null));
        rm.done();
    }

    public <V extends IDMData> void getModelData(IDMContext<V> dmc, DataRequestMonitor<V> rm) {
        if (dmc == this.fExecutionDmc) {
            rm.setData((Object)this.getExecutionData());
        } else if (dmc == this.fServiceDmc) {
            rm.setData((Object)this);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
        }
        rm.done();
    }

    public MICommandCache getCache() {
        return this.fMICommandCache;
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIRunningEvent e) {
        this.getSession().dispatchEvent((Object)new ResumedEvent(this.fExecutionDmc, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ResumedEvent e) {
        this.fSuspended = false;
        this.fResumePending = false;
        this.fMICommandCache.setTargetAvailable(false);
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fStepping = true;
        } else {
            this.fMICommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIStoppedEvent e) {
        this.getSession().dispatchEvent((Object)new SuspendedEvent(this.fExecutionDmc, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(SuspendedEvent e) {
        this.fMICommandCache.setTargetAvailable(true);
        this.fMICommandCache.reset();
        this.fSuspended = true;
        this.fStepping = false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIGDBExitEvent e) {
        if (this.fTerminated) {
            return;
        }
        this.getSession().dispatchEvent((Object)new ExitedEvent(this.fServiceDmc, e, this.fExecutionDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIInferiorExitEvent e) {
        if (this.fTerminated) {
            return;
        }
        this.getSession().dispatchEvent((Object)new ExitedEvent(this.fServiceDmc, e, this.fExecutionDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIInferiorSignalExitEvent e) {
        if (this.fTerminated) {
            return;
        }
        this.getSession().dispatchEvent((Object)new ExitedEvent(this.fServiceDmc, e, this.fExecutionDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIThreadExitEvent e) {
        if (this.fTerminated) {
            return;
        }
        this.getSession().dispatchEvent((Object)new ExitedEvent(this.fServiceDmc, e, this.fExecutionDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.fTerminated = false;
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public boolean canResume(IDMContext<?> context) {
        return !this.fTerminated && this.isSuspended(context) && !this.fResumePending;
    }

    public boolean canSuspend(IDMContext<?> context) {
        return !this.fTerminated && !this.isSuspended(context);
    }

    public boolean isSuspended(IDMContext<?> context) {
        return !this.fTerminated && this.fSuspended;
    }

    public boolean isStepping(IDMContext<?> context) {
        return !this.fTerminated && this.fStepping;
    }

    public void resume(IDMContext<?> context, final RequestMonitor rm) {
        if (this.canResume(context)) {
            this.fResumePending = true;
            this.fMICommandCache.setTargetAvailable(false);
            DsfMIExecRun cmd = new DsfMIExecRun(new String[0]);
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){

                protected void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + ", is already running.", null));
            rm.done();
        }
    }

    public void suspend(IDMContext<?> context, final RequestMonitor rm) {
        if (this.canSuspend(context)) {
            DsfMIExecInterrupt cmd = new DsfMIExecInterrupt();
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){

                protected void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + ", is already stopped.", null));
            rm.done();
        }
    }

    public boolean canStep(IDMContext<?> context) {
        return this.canResume(context);
    }

    public void step(IDMContext<?> context, IRunControl.StepType stepType, RequestMonitor rm) {
        if (!this.canResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        this.fResumePending = true;
        this.fStepping = true;
        this.fMICommandCache.setTargetAvailable(false);
        switch (stepType) {
            case STEP_INTO: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecStep(1), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){});
                break;
            }
            case STEP_OVER: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecNext(), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){});
                break;
            }
            case STEP_RETURN: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecFinish(), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){});
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Given step type not supported", null));
                rm.done();
            }
        }
    }

    public boolean canInstructionStep(IDMContext<?> context) {
        return false;
    }

    public void instructionStep(IDMContext<?> context, IRunControl.StepType stepType, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Operation not implemented", null));
        rm.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionDMC
    extends AbstractDMContext<IRunControl.IExecutionDMData>
    implements IRunControl.IExecutionDMContext {
        public ExecutionDMC(MIRunControl service) {
            super((IDMService)service, new IDMContext[]{service.getServiceContext()});
        }

        public String toString() {
            return this.baseToString() + ".thread";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    private class ExecutionData
    implements IRunControl.IExecutionDMData {
        private ExecutionData() {
        }

        public boolean isValid() {
            return !MIRunControl.this.fTerminated;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExitedEvent
    extends RunControlEvent<IRunControl.IContainerDMContext, DsfMIEvent>
    implements IRunControl.IExitedDMEvent {
        private IRunControl.IExecutionDMContext fExecDmc;

        public ExitedEvent(IRunControl.IContainerDMContext dmc, DsfMIEvent miInfo, IRunControl.IExecutionDMContext execDmc) {
            super(dmc, miInfo);
            this.fExecDmc = execDmc;
        }

        public IRunControl.IExecutionDMContext getExecutionContext() {
            return this.fExecDmc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, DsfMIRunningEvent>
    implements IRunControl.IResumedDMEvent {
        ResumedEvent(IRunControl.IExecutionDMContext dmc, DsfMIRunningEvent miInfo) {
            super(dmc, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((DsfMIRunningEvent)this.getMIEvent()).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunControlEvent<V extends IDMContext<?>, T extends DsfMIEvent>
    extends AbstractDMEvent<V>
    implements IDMEvent<V> {
        private T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceDMC
    extends AbstractDMContext<IRunControl.IExecutionDMData>
    implements IRunControl.IContainerDMContext {
        public ServiceDMC(MIRunControl service) {
            super((IDMService)service, new IDMContext[0]);
        }

        public String toString() {
            return this.baseToString() + "#run_control";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, DsfMIStoppedEvent>
    implements IRunControl.ISuspendedDMEvent {
        SuspendedEvent(IRunControl.IExecutionDMContext dmc, DsfMIStoppedEvent miInfo) {
            super(dmc, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof DsfMIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof DsfMISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
    }
}

