/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepQueueManager
extends AbstractDsfService
implements IStepQueueManager {
    private IRunControl fRunControl;
    private int fQueueDepth = 3;
    private Map<IRunControl.IExecutionDMContext, List<StepRequest>> fStepQueues = new HashMap<IRunControl.IExecutionDMContext, List<StepRequest>>();
    private Map<IRunControl.IExecutionDMContext, Boolean> fTimedOutFlags = new HashMap<IRunControl.IExecutionDMContext, Boolean>();
    private Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fTimedOutFutures = new HashMap();

    public StepQueueManager(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(this.getExecutor(), requestMonitor){

            protected void handleOK() {
                StepQueueManager.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IStepQueueManager.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public boolean canEnqueueStep(IDMContext<?> ctx) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IExecutionDMContext.class);
        return execCtx != null && (this.fRunControl.isSuspended((IDMContext)execCtx) && this.fRunControl.canStep((IDMContext)execCtx) || this.fRunControl.isStepping((IDMContext)execCtx) && !this.isSteppingTimedOut((IDMContext<?>)execCtx));
    }

    public boolean canEnqueueInstructionStep(IDMContext<?> ctx) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IExecutionDMContext.class);
        return execCtx != null && (this.fRunControl.isSuspended((IDMContext)execCtx) && this.fRunControl.canInstructionStep((IDMContext)execCtx) || this.fRunControl.isStepping((IDMContext)execCtx) && !this.isSteppingTimedOut((IDMContext<?>)execCtx));
    }

    public int getPendingStepCount(IDMContext<?> execCtx) {
        List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
        if (stepQueue == null) {
            return 0;
        }
        return stepQueue.size();
    }

    public void enqueueStep(IDMContext<?> ctx, IRunControl.StepType stepType) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IExecutionDMContext.class);
        if (execCtx != null) {
            if (this.fRunControl.canStep((IDMContext)execCtx)) {
                this.fRunControl.step((IDMContext)execCtx, stepType, new RequestMonitor(this.getExecutor(), null));
            } else if (this.canEnqueueStep((IDMContext<?>)execCtx)) {
                List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
                if (stepQueue == null) {
                    stepQueue = new LinkedList<StepRequest>();
                    this.fStepQueues.put(execCtx, stepQueue);
                }
                if (stepQueue.size() < this.fQueueDepth) {
                    stepQueue.add(new StepRequest(stepType, false));
                }
            }
        }
    }

    public void enqueueInstructionStep(IDMContext<?> ctx, IRunControl.StepType stepType) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(ctx, IRunControl.IExecutionDMContext.class);
        if (execCtx != null) {
            if (this.fRunControl.canInstructionStep((IDMContext)execCtx)) {
                this.fRunControl.instructionStep((IDMContext)execCtx, stepType, new RequestMonitor(this.getExecutor(), null));
            } else if (this.canEnqueueInstructionStep((IDMContext<?>)execCtx)) {
                List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
                if (stepQueue == null) {
                    stepQueue = new LinkedList<StepRequest>();
                    this.fStepQueues.put(execCtx, stepQueue);
                }
                if (stepQueue.size() < this.fQueueDepth) {
                    stepQueue.add(new StepRequest(stepType, true));
                }
            }
        }
    }

    public boolean isSteppingTimedOut(IDMContext<?> context) {
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType(context, IRunControl.IExecutionDMContext.class);
        if (execCtx != null) {
            return this.fTimedOutFlags.containsKey(execCtx) ? this.fTimedOutFlags.get(execCtx) : false;
        }
        return false;
    }

    public int getStepQueueDepth() {
        return this.fQueueDepth;
    }

    public void setStepQueueDepth(int depth) {
        this.fQueueDepth = depth;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fTimedOutFlags.remove(e.getDMContext());
        ScheduledFuture<?> future = this.fTimedOutFutures.remove(e.getDMContext());
        if (future != null) {
            future.cancel(false);
        }
        if (this.fStepQueues.containsKey(e.getDMContext())) {
            List<StepRequest> queue = this.fStepQueues.get(e.getDMContext());
            StepRequest request = queue.remove(queue.size() - 1);
            if (queue.isEmpty()) {
                this.fStepQueues.remove(e.getDMContext());
            }
            if (request.fIsInstructionStep) {
                if (this.fRunControl.canInstructionStep(e.getDMContext())) {
                    this.fRunControl.instructionStep(e.getDMContext(), request.fStepType, new RequestMonitor(this.getExecutor(), null));
                } else {
                    this.fStepQueues.remove(e.getDMContext());
                }
            } else if (this.fRunControl.canStep(e.getDMContext())) {
                this.fRunControl.step(e.getDMContext(), request.fStepType, new RequestMonitor(this.getExecutor(), null));
            } else {
                this.fStepQueues.remove(e.getDMContext());
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.IResumedDMEvent e) {
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.FALSE);
            assert (!this.fTimedOutFutures.containsKey(e.getDMContext()));
            this.fTimedOutFutures.put((IRunControl.IExecutionDMContext)e.getDMContext(), this.getExecutor().schedule((Runnable)new DsfRunnable(){

                public void run() {
                    StepQueueManager.this.fTimedOutFutures.remove(e.getDMContext());
                    StepQueueManager.this.getSession().dispatchEvent((Object)new IStepQueueManager.ISteppingTimedOutEvent(){

                        public IRunControl.IExecutionDMContext getDMContext() {
                            return (IRunControl.IExecutionDMContext)e.getDMContext();
                        }
                    }, StepQueueManager.this.getProperties());
                }
            }, 500L, TimeUnit.MILLISECONDS));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IStepQueueManager.ISteppingTimedOutEvent e) {
        this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.TRUE);
    }

    private static class StepRequest {
        IRunControl.StepType fStepType;
        boolean fIsInstructionStep;

        StepRequest(IRunControl.StepType type, boolean instruction) {
            this.fStepType = type;
            this.fIsInstructionStep = instruction;
        }
    }
}

