/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.util.LinkedList;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecContinue;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecFinish;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNext;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNextInstruction;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecReturn;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStep;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStepInstruction;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecUntil;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMINotifyAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStatusAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIFunctionFinishedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMILocationReachedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIRunningEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISignalEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISteppingRangeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointScopeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointTriggerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIEventProcessor
implements IEventListener,
ICommandListener {
    private final ICommandControl fConnection;

    public MIEventProcessor(ICommandControl connection) {
        this.fConnection = connection;
        connection.addEventListener((IEventListener)this);
        connection.addCommandListener((ICommandListener)this);
    }

    public void dispose() {
        this.fConnection.removeEventListener((IEventListener)this);
        this.fConnection.removeCommandListener((ICommandListener)this);
    }

    public void eventReceived(Object output) {
        for (DsfMIOOBRecord oobr : ((DsfMIOutput)output).getMIOOBRecords()) {
            if (oobr instanceof DsfMIExecAsyncOutput) {
                DsfMIExecAsyncOutput exec = (DsfMIExecAsyncOutput)oobr;
                String state = exec.getAsyncClass();
                if (!"stopped".equals(state)) continue;
                LinkedList<DsfMIEvent> events = new LinkedList<DsfMIEvent>();
                DsfMIResult[] results = exec.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    String reason;
                    DsfMIEvent e;
                    String var = results[i].getVariable();
                    DsfMIValue val = results[i].getMIValue();
                    if (!var.equals("reason") || !(val instanceof DsfMIConst) || (e = this.createEvent(reason = ((DsfMIConst)val).getString(), exec)) == null) continue;
                    events.add(e);
                }
                if (events.isEmpty()) {
                    DsfMIStoppedEvent e = new DsfMIStoppedEvent(exec);
                    events.add(e);
                }
                for (DsfMIEvent event : events) {
                    this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
                }
                continue;
            }
            if (!(oobr instanceof DsfMIStatusAsyncOutput) && !(oobr instanceof DsfMINotifyAsyncOutput)) continue;
        }
    }

    DsfMIEvent createEvent(String reason, DsfMIExecAsyncOutput exec) {
        DsfMIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = new DsfMIBreakpointHitEvent(exec);
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = new DsfMIWatchpointTriggerEvent(exec);
        } else if ("watchpoint-scope".equals(reason)) {
            event = new DsfMIWatchpointScopeEvent(exec);
        } else if ("end-stepping-range".equals(reason)) {
            event = new DsfMISteppingRangeEvent(exec);
        } else if ("signal-received".equals(reason)) {
            event = new DsfMISignalEvent(exec);
        } else if ("location-reached".equals(reason)) {
            event = new DsfMILocationReachedEvent(exec);
        } else if ("function-finished".equals(reason)) {
            event = new DsfMIFunctionFinishedEvent(exec);
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = new DsfMIInferiorExitEvent(exec);
        } else if ("exited-signalled".equals(reason)) {
            event = new DsfMIInferiorSignalExitEvent(exec);
        }
        return event;
    }

    public void commandQueued(ICommand command) {
    }

    public void commandSent(ICommand command) {
    }

    public void commandRemoved(ICommand command) {
    }

    public void commandDone(ICommand<?> cmd, ICommandResult result) {
        DsfMIInfo cmdResult = (DsfMIInfo)result;
        DsfMIOutput output = cmdResult.getMIOutput();
        DsfMIResultRecord rr = output.getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("running".equals(state)) {
                int type = 0;
                type = cmd instanceof DsfMIExecNext ? 1 : (cmd instanceof DsfMIExecNextInstruction ? 2 : (cmd instanceof DsfMIExecStep ? 3 : (cmd instanceof DsfMIExecStepInstruction ? 4 : (cmd instanceof DsfMIExecUntil ? 6 : (cmd instanceof DsfMIExecFinish ? 5 : (cmd instanceof DsfMIExecReturn ? 7 : (cmd instanceof DsfMIExecContinue ? 0 : 0)))))));
                DsfMIRunningEvent event = new DsfMIRunningEvent(id, type);
                this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
            } else if ("exit".equals(state) || "connected".equals(state) || "error".equals(state)) {
                // empty if block
            }
        }
    }
}

