/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.object.SpiritSignal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritBusDefinitionDocument
extends SpiritDocument {
    public static final String DOCUMENT_TYPE = "busDefinition";

    @Override
    public String getRootTagName() {
        return DOCUMENT_TYPE;
    }

    public List<SpiritSignal> getSignals() {
        ArrayList<SpiritSignal> signals = new ArrayList<SpiritSignal>();
        try {
            XPathExpression e = null;
            XPath xPath = this.createXPath();
            e = xPath.compile("//spirit:signals/spirit:signal");
            NodeList signalNodes = (NodeList)e.evaluate(this.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < signalNodes.getLength(); ++i) {
                Element signalNode = (Element)signalNodes.item(i);
                signals.add(new SpiritSignal(this, signalNode));
            }
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        return signals;
    }

    public List<Node> resolveExtends(SpiritLibrary library) throws Exception {
        ArrayList<Node> extendedSignalNodes;
        XPath xPath = this.createXPath();
        Element extendNode = (Element)xPath.evaluate("//spirit:extends", this.getDocumentElement(), XPathConstants.NODE);
        if (extendNode != null) {
            Vlnv baseVlnv = new Vlnv(extendNode);
            SpiritDocument doc = library.get(baseVlnv);
            if (doc == null) {
                throw new Exception(Messages.SpiritBusDefinitionDocument_UnableToLocateBusDefinition + baseVlnv);
            }
            if (!(doc instanceof SpiritBusDefinitionDocument)) {
                throw new Exception(Messages.SpiritBusDefinitionDocument_DoesNotReferToBusDefinition + baseVlnv);
            }
            extendedSignalNodes = ((SpiritBusDefinitionDocument)doc).resolveExtends(library);
        } else {
            extendedSignalNodes = new ArrayList();
        }
        NodeList signalList = (NodeList)xPath.evaluate("//spirit:signals/spirit:signal", this.getDocumentElement(), XPathConstants.NODESET);
        for (int i = 0; i < signalList.getLength(); ++i) {
            Node thisSignal = signalList.item(i);
            extendedSignalNodes.add(thisSignal);
        }
        return extendedSignalNodes;
    }
}

