/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.util.ArrayList;
import java.util.TreeMap;

public abstract class LibraryNode {
    private LibraryNode parent = null;
    protected TreeMap<String, LibraryNode> children = null;

    public void removeChild(LibraryNode nodeToRemove) {
        this.children.remove(nodeToRemove.getContent());
    }

    public LibraryNode[] getChildren() {
        ArrayList<LibraryNode> a = new ArrayList<LibraryNode>();
        if (this.children != null) {
            a.addAll(this.children.values());
        }
        return a.toArray(new LibraryNode[a.size()]);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public abstract String getContent();

    void addChild(LibraryNode nodeToAdd) {
        if (this.children == null) {
            this.children = new TreeMap();
        }
        this.children.put(nodeToAdd.getContent(), nodeToAdd);
        nodeToAdd.setParent(this);
    }

    private void setParent(LibraryNode node) {
        this.parent = node;
    }

    public LibraryNode getParent() {
        return this.parent;
    }
}

