/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.SpiritCorePlugin;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.ComponentGroupNode;
import org.eclipse.dd.ipxact.editor.core.library.ComponentNode;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.IModelChangeListener;
import org.eclipse.dd.ipxact.editor.core.library.LibraryNode;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritLibrary {
    public static final String[] SPIRIT_FILE_EXTENSIONS = new String[]{".spirit", ".xml"};
    public static final List<String> SPIRIT_FILE_EXTENSION_LIST = Arrays.asList(SPIRIT_FILE_EXTENSIONS);
    private static SpiritLibrary defaultSpiritLibrary;
    private static SpiritLibrary defaultNonPluginSpiritLibrary;
    Map<File, FileDetails> fileMap = new HashMap<File, FileDetails>();
    private Map<Vlnv, FileDetails> vlnvMap = new HashMap<Vlnv, FileDetails>();
    private ComponentGroupNode rootNode = new ComponentGroupNode();
    private ListenerList listeners = new ListenerList();
    private IResourceChangeListener resourceChangeListener;

    private SpiritLibrary(boolean useWorkspace) {
        if (useWorkspace) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta change = event.getDelta();
                    if (change != null) {
                        List<IResourceDelta> list = this.getChangeList(change, null);
                        if (!list.isEmpty()) {
                            SpiritLibrary.this.update(list);
                        }
                    } else {
                        IPath location;
                        IResource resource = event.getResource();
                        if (resource instanceof IProject && (location = resource.getLocation()) != null) {
                            SpiritLibrary.this.update(location.toFile());
                        }
                    }
                }

                private List<IResourceDelta> getChangeList(IResourceDelta change, List<IResourceDelta> list) {
                    IResource resource;
                    IResourceDelta[] children;
                    if (list == null) {
                        list = new ArrayList<IResourceDelta>();
                    }
                    if ((children = change.getAffectedChildren()) != null && children.length > 0) {
                        for (IResourceDelta delta : children) {
                            this.getChangeList(delta, list);
                        }
                    }
                    if (SPIRIT_FILE_EXTENSION_LIST.contains(SpiritLibrary.getExtension((resource = change.getResource()).getName()).toLowerCase())) {
                        list.add(change);
                    }
                    return list;
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        }
    }

    public synchronized void dispose() {
        if (defaultSpiritLibrary != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(SpiritLibrary.defaultSpiritLibrary.resourceChangeListener);
            defaultSpiritLibrary = null;
        }
    }

    public static SpiritLibrary getNonPluginDefault() {
        if (defaultNonPluginSpiritLibrary == null) {
            defaultNonPluginSpiritLibrary = new SpiritLibrary(false);
        }
        return defaultNonPluginSpiritLibrary;
    }

    public static SpiritLibrary getDefault() {
        if (defaultSpiritLibrary == null) {
            defaultSpiritLibrary = new SpiritLibrary(true);
        }
        return defaultSpiritLibrary;
    }

    public static SpiritLibrary getInstance() {
        return new SpiritLibrary(false);
    }

    public synchronized void clear() {
        this.fileMap.clear();
        this.vlnvMap.clear();
        this.rootNode.children.clear();
        this.fireModelChanged();
    }

    public synchronized void addListener(IModelChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public synchronized void removeListener(IModelChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireModelChanged() {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).modelChanged();
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    private void fireDuplicateAdded(Vlnv vlnv, File file) {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).duplicateAdded(vlnv, file);
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    private void fireDuplicateRemoved(Vlnv vlnv, File file) {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).duplicateRemoved(vlnv, file);
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    public synchronized Vlnv addFile(File file) throws Exception {
        SpiritDocument doc;
        Vlnv vlnv;
        FileDetails fileDetails = this.fileMap.get(file);
        if (fileDetails != null) {
            if (fileDetails.getInitialModifiedTimestamp() == file.lastModified()) {
                return fileDetails.getVlnv();
            }
            this.removeFile(file);
            fileDetails = null;
        }
        if ((vlnv = (doc = SpiritDocumentFactory.getFactory().create(file.getAbsolutePath())).getVlnv()) != null) {
            fileDetails = new FileDetails(file, doc, vlnv);
            FileDetails primaryEntry = this.vlnvMap.get(vlnv);
            if (primaryEntry == null) {
                this.vlnvMap.put(vlnv, fileDetails);
            } else {
                if (primaryEntry.getDuplicate(file) != null) {
                    return fileDetails.getVlnv();
                }
                primaryEntry.addDuplicate(fileDetails);
                this.fireDuplicateAdded(vlnv, file);
            }
            this.fileMap.put(file, fileDetails);
            this.addComponentToTree(fileDetails);
        }
        this.fireModelChanged();
        return vlnv;
    }

    void removeFile(File file) {
        FileDetails fileDetails = this.fileMap.get(file);
        if (fileDetails != null) {
            Vlnv vlnv = fileDetails.getVlnv();
            if (vlnv != null) {
                FileDetails primaryEntry = this.vlnvMap.get(vlnv);
                if (fileDetails != primaryEntry) {
                    primaryEntry.removeDuplicate(file);
                    this.fireDuplicateRemoved(vlnv, file);
                } else {
                    this.vlnvMap.remove(vlnv);
                    Map<File, FileDetails> duplicates = primaryEntry.getDuplicates();
                    if (duplicates != null) {
                        primaryEntry = duplicates.values().iterator().next();
                        File primaryEntryFile = primaryEntry.getFile();
                        assert (this.fileMap.containsKey(primaryEntryFile));
                        duplicates.remove(primaryEntryFile);
                        primaryEntry.setDuplicates(duplicates.isEmpty() ? null : duplicates);
                        this.vlnvMap.put(vlnv, primaryEntry);
                        this.fireDuplicateRemoved(vlnv, primaryEntryFile);
                    }
                }
            }
            this.removeComponentFromTree(fileDetails);
            this.fileMap.remove(file);
            this.fireModelChanged();
        }
    }

    public static String getExtension(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return fileName.substring(pos);
    }

    public synchronized Vlnv getVlnvForFile(File file) {
        Vlnv vlnv = null;
        FileDetails details = this.fileMap.get(file);
        if (details != null) {
            vlnv = details.getVlnv();
        }
        return vlnv;
    }

    public synchronized FileDetails getFileDetailsForFile(File file) {
        return this.fileMap.get(file);
    }

    public synchronized FileDetails getFileDetailsForVlnv(Vlnv vlnv) {
        return this.vlnvMap.get(vlnv);
    }

    public synchronized List<FileDetails> getFileDetails() {
        return new ArrayList<FileDetails>(this.fileMap.values());
    }

    public synchronized List<FileDetails> getDuplicates(Vlnv vlnv) {
        Map<File, FileDetails> duplicateMap;
        ArrayList<FileDetails> duplicates = new ArrayList<FileDetails>();
        FileDetails primaryFileDetails = this.vlnvMap.get(vlnv);
        if (primaryFileDetails != null && (duplicateMap = primaryFileDetails.getDuplicates()) != null) {
            duplicates.addAll(duplicateMap.values());
        }
        return duplicates;
    }

    public synchronized SpiritDocument get(Document doc) {
        assert (doc != null);
        Vlnv vlnv = Vlnv.getVlnvForXmlDocument(doc);
        if (vlnv != null) {
            return this.get(vlnv);
        }
        return null;
    }

    public synchronized SpiritDocument get(Vlnv vlnv) {
        FileDetails fileDetails = this.vlnvMap.get(vlnv);
        if (fileDetails != null) {
            return fileDetails.getSpiritDocument();
        }
        return null;
    }

    public synchronized Vlnv[] getVlnvList() {
        Set<Vlnv> resultList = this.vlnvMap.keySet();
        return resultList.toArray(new Vlnv[0]);
    }

    public boolean isEmpty() {
        return this.vlnvMap.isEmpty();
    }

    public synchronized Set<String> getVendors() {
        HashSet<String> result = new HashSet<String>();
        Set<Vlnv> vlnvList = this.vlnvMap.keySet();
        Iterator<Vlnv> it = vlnvList.iterator();
        while (it.hasNext()) {
            result.add(it.next().getVendor());
        }
        return result;
    }

    public synchronized Set<String> getLibraries(String vendor) {
        HashSet<String> result = new HashSet<String>();
        Set<Vlnv> vlnvList = this.vlnvMap.keySet();
        for (Vlnv vlnv : vlnvList) {
            if (!vlnv.getVendor().equals(vendor)) continue;
            result.add(vlnv.getLibrary());
        }
        return result;
    }

    public synchronized Set<String> getNames(String vendor, String libname) {
        HashSet<String> result = new HashSet<String>();
        Set<Vlnv> vlnvList = this.vlnvMap.keySet();
        for (Vlnv vlnv : vlnvList) {
            if (!vlnv.getVendor().equals(vendor) || !vlnv.getLibrary().equals(libname)) continue;
            result.add(vlnv.getName());
        }
        return result;
    }

    public synchronized Set<String> getVersions(String vendor, String libname, String name) {
        HashSet<String> result = new HashSet<String>();
        Set<Vlnv> vlnvList = this.vlnvMap.keySet();
        for (Vlnv vlnv : vlnvList) {
            if (!vlnv.getVendor().equals(vendor) || !vlnv.getLibrary().equals(libname) || !vlnv.getName().equals(name)) continue;
            result.add(vlnv.getVersion());
        }
        return result;
    }

    public synchronized ComponentGroupNode getRoot() {
        return this.rootNode;
    }

    private void addComponentToTree(FileDetails fileDetails) {
        Vlnv vlnv = fileDetails.getVlnv();
        ComponentGroupNode vendorNode = this.rootNode.findOrCreateChild(1, vlnv);
        ComponentGroupNode libraryNode = vendorNode.findOrCreateChild(2, vlnv);
        ComponentGroupNode nameNode = libraryNode.findOrCreateChild(3, vlnv);
        ComponentNode node = new ComponentNode(fileDetails);
        nameNode.addChild(node);
    }

    private void removeComponentFromTree(FileDetails fileDetails) {
        Vlnv vlnv;
        ComponentGroupNode vendorNode;
        if (fileDetails != null && (vendorNode = this.rootNode.findChild(1, vlnv = fileDetails.getVlnv())) != null) {
            ComponentGroupNode libraryNode = vendorNode.findChild(2, vlnv);
            if (libraryNode != null) {
                ComponentGroupNode nameNode = libraryNode.findChild(3, vlnv);
                if (nameNode != null) {
                    LibraryNode[] children;
                    for (LibraryNode node : children = nameNode.getChildren()) {
                        if (!fileDetails.equals(((ComponentNode)node).getFileDetails())) continue;
                        nameNode.removeChild(node);
                    }
                    if (!nameNode.hasChildren()) {
                        libraryNode.removeChild(nameNode);
                    }
                }
                if (!libraryNode.hasChildren()) {
                    vendorNode.removeChild(libraryNode);
                }
            }
            if (!vendorNode.hasChildren()) {
                this.rootNode.removeChild(vendorNode);
            }
        }
    }

    public synchronized LibraryNode getNode(Vlnv vlnv) {
        ComponentGroupNode nameNode;
        ComponentGroupNode libraryNode;
        ComponentGroupNode vendorNode;
        SpiritDocument spiritDocument;
        FileDetails fileDetails;
        if (vlnv != null && (fileDetails = this.vlnvMap.get(vlnv)) != null && (spiritDocument = fileDetails.getSpiritDocument()) != null && (vendorNode = this.rootNode.findChild(1, vlnv)) != null && (libraryNode = vendorNode.findChild(2, vlnv)) != null && (nameNode = libraryNode.findChild(3, vlnv)) != null) {
            LibraryNode[] children;
            for (LibraryNode node : children = nameNode.getChildren()) {
                if (!((ComponentNode)node).getFileDetails().getSpiritDocument().equals(spiritDocument)) continue;
                return node;
            }
        }
        return null;
    }

    public void update(long delay) {
        class LibraryUpdateJob
        extends Job {
            public LibraryUpdateJob() {
                super(Messages.SpiritLibrary_LibraryUpdate);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.SpiritLibrary_Update, -1);
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects != null) {
                    final HashSet currentFiles = new HashSet();
                    for (IProject project : projects) {
                        IResourceVisitor visitor = new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource.exists() && SPIRIT_FILE_EXTENSION_LIST.contains(SpiritLibrary.getExtension(resource.getName()).toLowerCase())) {
                                    try {
                                        File file = resource.getLocation().toFile();
                                        SpiritLibrary.this.addFile(file);
                                        currentFiles.add(file);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return true;
                            }
                        };
                        try {
                            project.accept(visitor);
                        }
                        catch (CoreException ce) {
                            // empty catch block
                        }
                        HashSet<File> filesToRemove = new HashSet<File>();
                        for (File file : SpiritLibrary.this.fileMap.keySet()) {
                            if (currentFiles.contains(file)) continue;
                            filesToRemove.add(file);
                        }
                        for (File file : filesToRemove) {
                            SpiritLibrary.this.removeFile(file);
                        }
                        if (!monitor.isCanceled()) continue;
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }
        new LibraryUpdateJob().schedule(delay);
    }

    void update(final List<IResourceDelta> list) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LibraryUpdateJob
        extends Job {
            public LibraryUpdateJob() {
                super(Messages.SpiritLibrary_LibraryUpdate);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.SpiritLibrary_Update, list.size());
                for (IResourceDelta delta : list) {
                    boolean isLinked;
                    IResource resource = delta.getResource();
                    if (2 == delta.getKind() && (isLinked = resource.isLinked(512))) {
                        SpiritLibrary.this.clear();
                        SpiritLibrary.this.update(0L);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    IPath location = resource.getLocation();
                    if (location != null) {
                        try {
                            File file = location.toFile();
                            switch (delta.getKind()) {
                                case 2: {
                                    SpiritLibrary.this.removeFile(file);
                                    break;
                                }
                                case 1: {
                                    SpiritLibrary.this.addFile(file);
                                    break;
                                }
                                case 4: {
                                    if ((delta.getFlags() & 0x20000) == 0) {
                                        SpiritLibrary.this.removeFile(file);
                                        SpiritLibrary.this.addFile(file);
                                    }
                                    break;
                                }
                                default: {
                                    SpiritCorePlugin.logErrorMessage(Messages.SpiritLibrary_Unsupported + delta + Messages.SpiritLibrary_Kind + delta.getKind());
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }
        new LibraryUpdateJob().schedule();
    }

    void update(final File dir) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LibraryUpdateJob
        extends Job {
            public LibraryUpdateJob() {
                super(Messages.SpiritLibrary_LibraryUpdate);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.SpiritLibrary_Update, -1);
                this.removeFileOrDirectory(monitor, dir);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private void removeFileOrDirectory(IProgressMonitor monitor, File file) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (file.isDirectory()) {
                    for (File child : file.listFiles()) {
                        this.removeFileOrDirectory(monitor, child);
                    }
                } else if (file.isFile() && SPIRIT_FILE_EXTENSION_LIST.contains(SpiritLibrary.getExtension(file.getName()).toLowerCase())) {
                    SpiritLibrary.this.removeFile(file);
                }
            }
        }
        new LibraryUpdateJob().schedule();
    }
}

