/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.object;

import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.object.SpiritObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SpiritSignal
extends SpiritObject {
    public static final int ON_SYSTEM = 0;
    public static final int ON_MASTER = 1;
    public static final int ON_SLAVE = 2;
    private static final String[] logicalNames = new String[]{"onSystem", "onMaster", "onSlave"};
    private String name;
    public SignalInfo[] signalInfos;

    public SpiritSignal(SpiritDocument sDoc, Element signalElement) {
        String namespace = sDoc.getSchemaURI();
        Element element = SpiritDocument.getFirstElementByTagNameNS(signalElement, namespace, "logicalName");
        this.name = element != null ? element.getTextContent() : "";
        this.signalInfos = new SignalInfo[]{null, null, null};
        for (int index = 0; index <= 2; ++index) {
            element = SpiritDocument.getFirstElementByTagNameNS(signalElement, namespace, logicalNames[index]);
            if (element == null) continue;
            this.signalInfos[index] = this.getSignalInfo(element, namespace);
        }
    }

    private SignalInfo getSignalInfo(Element busTypeElement, String namespace) {
        SignalInfo signalInfo = new SignalInfo();
        Element element = SpiritDocument.getFirstElementByTagNameNS(busTypeElement, namespace, "bitWidth");
        signalInfo.bitWidth = element != null ? element.getTextContent() : null;
        element = SpiritDocument.getFirstElementByTagNameNS(busTypeElement, namespace, "direction");
        signalInfo.direction = element != null ? element.getTextContent() : null;
        return signalInfo;
    }

    public String getName() {
        return this.name;
    }

    public SignalInfo getSignalInfo(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return this.signalInfos[index];
            }
        }
        return null;
    }

    public Element createNewNode(Document document) {
        Element newRootNode = null;
        newRootNode = document.createElement("spirit:signal");
        Element e = document.createElement("spirit:logicalName");
        Text text = document.createTextNode(this.name);
        e.appendChild(text);
        newRootNode.appendChild(e);
        for (int index = 0; index <= 2; ++index) {
            Element i;
            SignalInfo signalInfo = this.signalInfos[index];
            if (signalInfo == null) continue;
            e = document.createElement("spirit:" + logicalNames[index]);
            newRootNode.appendChild(e);
            if (signalInfo.bitWidth != null) {
                i = document.createElement("spirit:bitWidth");
                i.appendChild(document.createTextNode(signalInfo.bitWidth));
                e.appendChild(i);
            }
            if (signalInfo.direction == null) continue;
            i = document.createElement("spirit:bitWidth");
            i.appendChild(document.createTextNode(signalInfo.direction));
            e.appendChild(i);
        }
        return newRootNode;
    }

    public String toString() {
        return this.name;
    }

    public class SignalInfo {
        public String bitWidth;
        public String direction;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.direction);
            stringBuilder.append(',');
            stringBuilder.append(this.bitWidth);
            return stringBuilder.toString();
        }
    }
}

