/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.command.commands.CLIAttach;
import org.eclipse.dd.mi.service.command.commands.CLIMonitorListProcesses;
import org.eclipse.dd.mi.service.command.output.CLIMonitorListProcessesInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses
extends AbstractDsfService
implements IProcesses {
    private GDBControl fCommandControl;

    public GDBProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{IProcesses.class.getName(), GDBProcesses.class.getName()}, new Hashtable());
        this.fCommandControl = (GDBControl)((Object)this.getServicesTracker().getService(GDBControl.class));
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext process, String threadId) {
        return new GdbThreadDMC(this.getSession().getId(), process, threadId);
    }

    public IProcesses.IProcessDMContext createProcessContext(String pid) {
        return new GdbProcessDMC(this.getSession().getId(), pid);
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IProcesses.IThreadDMContext) {
            this.getExecutionData((IProcesses.IThreadDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof GdbProcessDMC) {
            rm.setData((Object)new GdbThreadDMData(this.fCommandControl.getExecutablePath().lastSegment(), ((GdbProcessDMC)dmc).getId()));
            rm.done();
        } else if (dmc instanceof GdbThreadDMC) {
            rm.setData((Object)new GdbThreadDMData("", ((GdbThreadDMC)dmc).getId()));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        if (procCtx instanceof GdbProcessDMC) {
            int pid;
            try {
                pid = Integer.parseInt(((GdbProcessDMC)procCtx).getId());
            }
            catch (NumberFormatException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Invalid process id.", null));
                rm.done();
                return;
            }
            this.fCommandControl.queueCommand((ICommand)new CLIAttach((IDMContext)procCtx, pid), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses.this.fCommandControl.getGDBDMContext());
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    public void detachDebuggerFromProcess(IProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void debugNewProcess(String file, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        this.fCommandControl.queueCommand((ICommand)new CLIMonitorListProcesses(dmc), (DataRequestMonitor)new DataRequestMonitor<CLIMonitorListProcessesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                IProcessInfo[] processes = ((CLIMonitorListProcessesInfo)this.getData()).getProcessList();
                GdbProcessDMC[] procDmcs = new GdbProcessDMC[processes.length];
                for (int i = 0; i < procDmcs.length; ++i) {
                    procDmcs[i] = GDBProcesses.this.createProcessContext(Integer.toString(processes[i].getPid()));
                }
            }
        });
    }

    public void runNewProcess(String file, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        if (thread instanceof GdbProcessDMC) {
            this.fCommandControl.terminate(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @Immutable
    protected class GdbProcessDMC
    extends GdbThreadDMC
    implements IProcesses.IProcessDMContext {
        protected GdbProcessDMC(String sessionId, String id) {
            super(sessionId, null, id);
        }

        public String toString() {
            return this.baseToString() + ".proc[" + this.getId() + "]";
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    @Immutable
    protected class GdbThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fOSId;

        protected GdbThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc != null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            } else {
                iDMContextArray = new IDMContext[]{};
            }
            super(sessionId, iDMContextArray);
            this.fOSId = id;
        }

        public String getId() {
            return this.fOSId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fOSId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((GdbThreadDMC)((Object)obj)).fOSId == this.fOSId;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fOSId.hashCode();
        }
    }

    @Immutable
    private static class GdbThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        GdbThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

